#!/usr/bin/env python3

from __future__ import print_function
import numpy as np
import matplotlib.pyplot as plt
from xlib.helper import real2realFFT

#set parameters for the input function exp(-t*t/2.) that to be transformed
dt = 0.01
tmax = 10.
t = np.arange(0,tmax,dt)
deltaf = 1/tmax
fmax=1./(2.*dt)
y=np.exp(-t*t/2.) #this is the input for fft

#Calculate the analytical FFT as the benckmark
analyticf = np.arange(-tmax,tmax-deltaf,deltaf)
analyticFFT = np.sqrt(2*np.pi)*np.exp(-2*np.pi*np.pi*analyticf*analyticf)

#XX's FFT
XXFFT, fre= real2realFFT(y,dt)

#direct FFT
directFFT = dt*np.fft.fftshift(np.fft.fft(y)).real
directFre=np.fft.fftshift(np.fft.fftfreq(directFFT.size))/dt

plt.figure()
plt.semilogy(analyticf, analyticFFT, label='analytic FFT')
plt.semilogy(fre, XXFFT, 'o', label='XX\'s FFT')
plt.semilogy(directFre, directFFT, 's', label='direct numpy FFT')
plt.xlim([-2,2])
plt.ylim([1e-31,10])
plt.title('Conclusion: the accuracy of XX implementation is only limited by the\n '
          'accuracy of double precision floating point number, which is 1e-16.\n'
          'Direct FFT cannot closely reproduce the analytical curve!!!')

plt.legend(loc=0)
plt.show()
