import numpy as np

def real2realFFT( rawin, deltaT=1., axis=0):
    s = [slice(None)]*rawin.ndim
    s[axis] = slice(-1,0,-1)

    fftin = np.concatenate((rawin[tuple(s)].conjugate(),rawin),axis=axis)
    fftin = np.ascontiguousarray(fftin)

    s = [np.newaxis]*fftin.ndim
    s[axis] = slice(None)

    fftout = np.fft.fftshift(np.fft.fft(fftin,axis=axis),axes=axis)*deltaT
    fre=np.fft.fftshift(np.fft.fftfreq(fftout.shape[axis]))/deltaT

    fftSize=fftout.shape[axis]
    s = [slice(None)]*fftin.ndim
    s[axis] = slice(fftSize//4,fftSize//4*3,1)
    fftout=fftout[tuple(s)]

    fre = fre[fftSize//4:fftSize//4*3]

    # print('real',np.abs(fftout.real).sum(), 'imag', np.abs(fftout.imag).sum())
    return np.abs(fftout.real), fre
