#include "RunStatus.hh"
#include <unistd.h>  //getpid
#include <nlohmann/json.hpp>
#include "Earthworm.hh"
#include <ctime>

RunStatus::RunStatus(const std::shared_ptr<RedisIO> &r,
const std::string &cmdpath, const std::string &hbpath )
:StateMachine(1), m_redis(std::shared_ptr<RedisIO>(r))
,m_cmdPath(cmdpath), m_heartBeatPath(hbpath)
,m_proID(getpid())
{

}

RunStatus::~RunStatus()
{

}

RunStatus::Command RunStatus::update()
{
  int cmdint = atoi(m_redis->readString(m_cmdPath).c_str());
  // int reply = m_redis->readString(m_cmdPath);
  if(cmdint>=0 && cmdint<kNumCommand)
  {
    transit(cmdint);
    return int2cmd(cmdint);
  }
  else
    return Command::kUnknown;
  // if(reply==0) //configure detector type and reset buffer
  //   m_state = State::kConfiguring;
  // else if(reply==2) //start accumulate data (RESET AGAIN HERE)
  //   m_state = State::kRunning;
  // else if(reply==3) //paused fill histogram, still receiving dim datastream but unprocessed
  //   m_state = State::kPaused;
  // //(kResume)
  // else if(reply==5) //stop, reset everythin (NOT RESET,  still receiving dim datastream but unprocessed)
  //    m_state = State::kConfiguring; //(start/unconfigure)
  // else if(reply==6) //abort
  //   m_state = State::kError; //this state will not send vis heartbeat
  // else
  // {
  //   EW_LOG_CRITICAL("unknow command \"{}\" received from cockpit. Earthworm state is unchanged.", reply);
  // }
}


std::string RunStatus::genHeartBeat() const
{
  nlohmann::json j;
  j["pid"] = m_proID;
  j["status"] = printState();

  std::time_t t = std::time(nullptr);
  char mbstr[100];
  if (std::strftime(mbstr, sizeof(mbstr), "%Y-%m-%dT%H:%M:%S.%03d+08:00", std::localtime(&t))) {
  }

  j["timestamp"] = std::string (mbstr);
  return j.dump();
}

void RunStatus::sendHeartBeat() const
{
  m_redis->writeString(m_heartBeatPath,genHeartBeat());
}
