#include "StateMachine.hh"

using State=StateMachine::State;
using Command=StateMachine::Command;

int main()
{
  StateMachine sm;
  //Define 9 allowed state transit
  //void grantStateTransit(State from, State to, Command byCommand);
  sm.grantStateTransit(State::kUnconfigured, State::kReady, Command::kConfigure);
  sm.grantStateTransit(State::kReady, State::kUnconfigured, Command::kUnconfigure);
  sm.grantStateTransit(State::kReady, State::kRunning, Command::kStart);
  sm.grantStateTransit(State::kRunning, State::kReady, Command::kStop);
  sm.grantStateTransit(State::kRunning, State::kPaused, Command::kPause);
  sm.grantStateTransit(State::kPaused, State::kRunning, Command::kResume);
  sm.grantStateTransit(State::kReady, State::kError, Command::kAbort);
  sm.grantStateTransit(State::kRunning, State::kError, Command::kAbort);
  sm.grantStateTransit(State::kPaused, State::kError, Command::kAbort);

  //selfDiagnosis() generates 10k state and command in random combination,
  //and record those in fact can change the state
  sm.selfDiagnosis();
  return 0;
}
