#include "EwMonitor.hh"
#include "Earthworm.hh"
#include "neutronClientStartMonitor.hh"
#include "EpicsClasses.hh"

EwMonitor::EwMonitor(std::string monitorName, unsigned numtof, double tofLower,
  double tofUpper, unsigned numPix, double pLower, double pUppder)
:m_active(false),
m_dron_monitor(new neutronClientStartMonitor(monitorName)),
hist2d(numtof, tofLower, tofUpper, numPix, pLower, pUppder)
{

}

EwMonitor::~EwMonitor()
{
  delete m_dron_monitor;
}

void EwMonitor::fill(double tof, double pid)
{
  std::lock_guard<std::mutex> guard(m_monitor_mutex);
  if(m_active)
  {
    hist2d.fill(tof,pid);
    printf("filling %d , %d\n", (int) tof, (int) pid);
  }
}


void EwMonitor::startWorker()
{
  std::function<void(double, double)> func =  std::bind( &EwMonitor::fill, this, std::placeholders::_1, std::placeholders::_2);
  m_dron_monitor->startMonitor(func);
}

void EwMonitor::start()
{
  m_active=true;
}

void EwMonitor::stop()
{
  m_active=false;
}

void EwMonitor::clear()
{
  if(m_active)
  {
    EW_LOG_WARN("Monitor::clear Monitor is actively accumulating data. return without clear up.");
  }
  std::lock_guard<std::mutex> guard(m_monitor_mutex);
  hist2d.reset();
}
