#!/usr/bin/python

from __future__ import print_function
import h5py
import numpy as np
import matplotlib.pyplot as plt

# (1000, 3333)

f=h5py.File('gtr.h5','r')
gtr=f['gtr'][()]
rSpacingInAa=f['rSpacingInAa'][()]
tSpacingInfs=f['tSpacingInfs'][()]
rScalefact=f['rScalefact'][()]
rSize=f['rSize'][()]
tSizef=f['tSize'][()]
f.close()

rRange = np.arange(rSize) *  rSpacingInAa
tRange = np.arange(tSizef) *  tSpacingInfs
qSize = rSize//2+1
qResolution = 1. / rSpacingInAa/rSize
qrange = np.arange(qSize) * qResolution

print('rSize', rSize)
print('tSizef', tSizef)
print('qSize', qSize)

idx = [1, 10, 67, 67*2 ,67*2**2, 67*2**3]
for i in idx:
    #plt.plot(spaRange,  gtr[:,i], label = str(tSpacingInfs*i)+'fs')
    plt.plot(rRange, rScalefact * gtr[i,:], label = str(tRange[i])+'fs')
    print('Integral ', np.trapz(rScalefact * gtr[i,:], rRange))
plt.xlabel('R, Aa')
plt.legend()
plt.title('Gr mult by 4pi*r*r')


############################
plt.figure()
ftq= np.abs(np.fft.rfft(gtr,axis=1)) # should not abs

print("ftq shape", ftq.shape)
idx = [1, 10, 67, 67*2 ,67*2**2]
for i in idx:
    plt.semilogx(tRange, ftq[:,i], label = str(qrange[i])+'Aa^-1')
plt.legend()
plt.title('Ft')

#
# plt.figure()
# sqw = np.abs(np.fft.rfft(fqt, axis=1))
# plt.imshow(np.log(sqw))
#
# plt.figure()
# plt.plot(sqw[1])
# plt.plot(sqw[10])
# plt.plot(sqw[100])


plt.title('Sw')







plt.show()
