#ifndef TrajAna_hh
#define TrajAna_hh
#include <stdexcept>
#include "ctypes_api.hh"

#include "ctypes_api.hh"

#ifdef __cplusplus
extern "C" {
#endif

void test(double* vec, unsigned vecsize)
{
  for(unsigned i=0;i<vecsize;i++)
  {
    printf("i %d, %g\n", i, vec[i]);
  }
}

class NumpyHist1D;
EXPORT_SYMBOL double vaf(double* vel, unsigned velSize,
  unsigned idx, unsigned nAtom, unsigned nStep);

EXPORT_SYMBOL void vaf_vec(double* vel, unsigned velSize,
             double* returnPointer, unsigned retsize,
             unsigned nAtom, unsigned nStep);

//returnPointer is G(t,r) *4*pi*r*r in numpy array
EXPORT_SYMBOL void gtr_vec(double* pos, unsigned posSize,
            double *box, unsigned boxSize,
            double* returnPointer, unsigned retsize,
            unsigned numSpatialBin, double wavelengthCut,
            double dltT, unsigned nAtom, unsigned nStep);

//Fill the histogram with the space time correlation of two atoms with a fixed lagTime
//in the reference of first atom position
EXPORT_SYMBOL void pairCorrelation(NumpyHist1D& hist, double* pos, unsigned posSize,
              double* pos2, unsigned posSize2,
              double *box, unsigned boxSize,
              unsigned timeIdx, unsigned nAtom, unsigned nStep);




#include "TrajAna.icc"

#ifdef __cplusplus
}
#endif

#endif
