#include "Earthworm.hh"
#include <iostream>
#include "spdlog/sinks/basic_file_sink.h" // support for basic file logging
#include "spdlog/sinks/rotating_file_sink.h" // support for rotating file logging


Earthworm* Earthworm::m_instance = 0;

Earthworm::Earthworm()
{}

Earthworm::~Earthworm()
{
  spdlog::shutdown();
}

const Earthworm * Earthworm::instance()
{
  static Earthworm instance;
  return &instance;
}

void Earthworm::enableFileLogger() const
{
  try
  {
      // create a file rotating logger with 1mb size max and 100 rotated files
      auto file_logger = spdlog::rotating_logger_mt("file_logger", "Earthworm.log", 1024 * 1024 * 5, 100);
      spdlog::set_default_logger(file_logger);
  }
  catch (const spdlog::spdlog_ex& ex)
  {
      std::cout << "Log initialization failed: " << ex.what() << std::endl;
  }
}
