#ifndef Parser_PackageHe3_hh
#define Parser_PackageHe3_hh

#include <map>
#include <mutex>

#include "ParserHe3.hh"

class Hist2DMap;

//This class reads information from a full package.
namespace Parser {
  struct HitInfo {
    double pos;
    double t;
    double chargesum;
    uint8_t tube_id;
    HitInfo(): pos(0.),t(0.),chargesum(0.),tube_id(0) {}
    HitInfo(double position, double time, double chargesum, uint8_t tube)
      : pos(position),t(time),chargesum(chargesum),tube_id(tube) {}
  };

  //Reflectormetor uses He3 detector of 300mm length.
  //time stamp should be divided by 80 to convert to micro-second
  //fixme :  put m_detector_half_length and m_tof2us elsewhere
  class EXPORT_SYMBOL PackageHe3: public ParserHe3 {
  public:
    PackageHe3(double threshold, double hvlength=150., double tofscale=1./80);

    ~PackageHe3() override;
    //fixme: hit position is scale by a constant 150
    //returns false when reach the end of the data stream
    bool readNextPackage(const uint8_t*& pt, const uint8_t * const stream_end, std::vector<HitInfo>& hitinfo) const;
    bool readNextPackage(const uint8_t*& pt, const uint8_t * const stream_end, Hist2DMap &hitmap) const;

    double getChargeThreshold() const;
    void setChargeThreshold(double charge);
  private:
    std::mutex m_mutex;
    double m_charge_threshold, m_detector_half_length, m_tof2us;
  };
}
#endif
