#ifndef Action_PMT_hh
#define Action_PMT_hh

#include "DAQInterfaceGPPD.hh"
#include "NumpyHist2D.hh"
#include "RedisIO.hh"
#include "RedisNumpy.hh"
#include "StateMachine.hh"
#include "Action.hh"
class DAQInterfaceGPPD;
class Action_PMT : public Action {
public:
	Action_PMT(RedisIO *redis, StateMachine *sMachine, std::string module);
	virtual ~Action_PMT();

	int getServerPid() {return m_active_daq->getServerPid(); }

	bool configure();
	//Stop running and clear any runtime determined parameter
  bool unconfigure();
  //Start accumulate data, RESET AGAIN HERE
	bool start();
	//Paused fill histogram, still receive but unprocess dim datastream
	bool pauseStop();
  //Back to unconfigure state
	bool abort();
  //Restart running;
	bool resume();
  //received kill command. Set m_kill so breakLoop can break external loops
	bool kill();
	bool keepRunning();

  void sendHeartbeat(bool stateAsStr=false);
  bool update();

//private:

	Hist2DMap::DetectorType m_detType;
	std::shared_ptr<NumpyHist2D> m_hist;
	StateMachine *m_sMachine;
	DAQInterfaceGPPD *m_active_daq;
  nlohmann::json m_allPath;
	std::chrono::time_point<std::chrono::steady_clock>  m_startTime;
	std::string m_module;
};


#endif
