#ifndef Action_MR_hh
#define Action_MR_hh

#include "DAQInterfaceMR.hh"
#include "Hist2DMap.hh"
#include "RedisIO.hh"
#include "RedisNumpy.hh"
#include "StateMachine.hh"
#include "Action.hh"

class Action_MR : public Action {
public:
	Action_MR(RedisIO *redis, StateMachine *sMachine);
	virtual ~Action_MR();

	bool configure();
	//Stop running and clear any runtime determined parameter
  bool unconfigure();
  //Start accumulate data, RESET AGAIN HERE
	bool start();
	//Paused fill histogram, still receive but unprocess dim datastream
	bool pauseStop();
  //Back to unconfigure state
	bool abort();
  //Restart running;
	bool resume();
  //received kill command. Set m_kill so breakLoop can break external loops
	bool kill();
	bool keepRunning();

  void sendHeartbeat(bool stateAsStr=false);
  bool update();

//private:

	Hist2DMap::DetectorType m_detType;
	std::shared_ptr<Hist2DMap> m_histmap;
	StateMachine *m_sMachine;
	DAQInterfaceMR *m_daq_he3;
	DAQInterfaceMR *m_daq_mwpc;
	DAQInterfaceMR *m_active_daq;
  nlohmann::json m_allPath;
	std::chrono::time_point<std::chrono::steady_clock>  m_startTime;
};


#endif
