#include "StateMachine.hh"
#include <iostream>
#include <functional>

class Action {
public:
  Action(){};
  ~Action(){};
  bool action1() {std::cout << "Executing action1." << '\n';return true;}
  bool action2() {std::cout << "Executing action2." << '\n';return true;}
};

int main()
{
  StateMachine sm;
  Action action;

  //void grantStateTransit(State from, State to, Command byCommand);


  sm.grantStateTransit(State::kUnconfigured, State::kReady, Command::kConfigure, std::bind( &Action::action1, action), "action1");
  sm.grantStateTransit(State::kReady, State::kUnconfigured, Command::kUnconfigure);
	sm.grantStateTransit(State::kReady, State::kUnconfigured, Command::kAbort);

  sm.grantStateTransit(State::kReady, State::kRunning, Command::kStart);
  sm.grantStateTransit(State::kRunning, State::kReady, Command::kStop);
  sm.grantStateTransit(State::kRunning, State::kPaused, Command::kPause);
  sm.grantStateTransit(State::kPaused, State::kRunning, Command::kResume);
  sm.grantStateTransit(State::kRunning, State::kUnconfigured, Command::kAbort);
  sm.grantStateTransit(State::kPaused, State::kUnconfigured, Command::kAbort);
	sm.grantStateTransit(State::kRunning, State::kRunning, Command::kStart);
	sm.grantGlobalTransitTo(State::kError, Command::kKill, std::bind( &Action::action2, action), "action2");

  //selfDiagnosis() generates 10k state and command in random combination,
  //and record those in fact can change the state
  sm.selfDiagnosis();

  sm.transit(0);

  return 0;
}
