#ifndef IncPARSERNXS
#define IncPARSERNXS

#include <string>
#include <map>
#include <vector>
#include <list>
#include <tinyxml.h>
#include "NeXusFile.hpp"
#include "parserXML.h"

class ParserNXS {
    public:
        ParserNXS(std::string beamline, std::string run, std::string filename)
        { 
	bl = beamline;
	runno = run;
	confName = filename;
	}

        //void getMonitorData(string filename,const int pids, const int tBins, std::vector<uint32_t> &histData);


        //void getHistData(string prepath, string runno, string filename, uint32_t* histData, bool bm);

	void getConfInfo();
        void createNXS();
        void setPublic(); 
        void setInstrument();
        void setMonitor(ParserXML conf_xml,ParserXML sum_xml, ParserXML idf_xml, map<string, string> fileList);
        void setHistData(); //set link for all module or monitor
        void setEventData(); //set link for all module or monitor
        //void setDetector(ParserXML idf_xml, ParserXML conf_xml, const vector<string> & moduleList);
        /*
        void setUser(ParseXML new_xml); //set default value
        void setProcess(); // set default value
        void setPresentData(const int timeBin, const int timeStep); // set random value
        */
    private:
        std::string bl;
	std::string runno;
	std::string confName;

	std::string nxsfile;
	std::string sumfile;
	std::string monitorfile;
	std::string idf_bank;
	std::string idf_monitor;

	int timeBin_bank;
	int timeStart_bank;
	int timeStep_bank;
	int timeEnd_bank;
	int delay_bank;
	int delay_monitor;
	int timeBin_monitor;
	int timeStart_monitor;
	int timeStep_monitor;
	int timeEnd_monitor;

	std::map<std::string, std::string> monitorFilelist;
	std::map<std::string, std::string> moduleFilelist;
	std::vector<std::string> moduleFilelist_sans;
	std::vector<std::string> moduleList;

        std::vector<std::string> split(string str, string sep);
        void coutMap(map<string, string> info);
        string int2string(int num);
        bool judgeVector(const vector<map<string, string> > &data);
        bool judgeMap(map<string, string> data);


	std::string getOneFile(const std::string &filepath, const std::string &midName, const std::string &suffixName);
	void getSumFile(ParserXML conf_xml);
	void getDAQFile(ParserXML conf_xml);
	void getMonFile(ParserXML conf_xml);
	void getNXSname(ParserXML conf_xml);
	void getIDFname(ParserXML conf_xml);


        void writeGroup(NXstatus status, NXhandle fileID, const char* groupName, const char* groupType);
        void writeCharData(NXstatus status, NXhandle fileID, const std::string dataName, const std::string dataValue);
        void writeNumData(NXstatus status, NXhandle fileID, const std::string dataName, const float* dataValue, int dimension, int dim[], std::string text);
        void writeNumData(NXstatus status, NXhandle fileID, const std::string dataName, const int64_t* dataValue, int dimension, int dim[], std::string text);
        void writeNumData(NXstatus status, NXhandle fileID, const std::string dataName, const uint64_t* dataValue, int dimension, int dim[], std::string text);
        void writeNumData(NXstatus status, NXhandle fileID, const std::string dataName, const uint32_t* dataValue, int dimension, int dim[], std::string text);
        void writeSlabData(NXstatus status, NXhandle fileID, const std::string dataName, const float* dataValue, int dim[], int slab_start[], int slab_size[], std::string text);
        void writeSlabData(NXstatus status, NXhandle fileID, const std::string dataName, const int64_t* dataValue, int dim[], int slab_start[], int slab_size[], std::string text);
        void writeSlabData(NXstatus status, NXhandle fileID, const std::string dataName, const uint32_t* dataValue, int dim[], int slab_start[], int slab_size[], std::string text);
        
        string getStringFromMap(const map<string, string> data, string name);
        float getFloatFromMap(const map<string, string> data, string name);
        int getIntFromMap(const map<string, string> data, string name);
        map<string, string> getMapFromVector(const vector<map<string, string> >& data, string keyword, string value);

	// second-level group in instrument
        void setModerator(NXstatus status, NXhandle fileID, const std::map<std::string, std::string>& info);
        void setSource(NXstatus status, NXhandle fileID, const std::map<std::string, std::string>& info);
        void setSample(NXstatus status, NXhandle fileID, const std::map<std::string, std::string>& info);
        void setDC(NXstatus status, NXhandle fileID, const std::vector<std::map<std::string, std::string>>& info);
        void setSE(NXstatus status, NXhandle fileID, const std::vector<std::map<std::string, std::string>>& info); 
        void setAperture(NXstatus status, NXhandle fileID, const std::vector<std::map<std::string, std::string>>& info, const std::string & name, const std::string & typeName);
        void setBank(NXstatus status, NXhandle fileID);
        void setMonitor(NXstatus status, NXhandle fileID);
        

        void setGeometry(NXstatus status, NXhandle fileID, string path, CSNSgeometry info);

        void setPid(NXstatus status, NXhandle fileID, int idstart, const int xpid, const int ypid);
        void setPidSize(NXstatus status, NXhandle fileID, float xstep,float ystep, const int xpid, const int ypid);
        void setCoordinate(NXstatus status, NXhandle fileID,float xpos, float ypos, float zpos, float xstep, float ystep, float rotValue, const int xpid, const int ypid);
        void setTof(NXstatus status, NXhandle fileID,const int tStart, const int tBin, const int tStep, const uint32_t delay);
	void setGPPDData(NXstatus status, NXhandle fileID, std::string filename,  const int pidNum, const int pidStart);
	void setSANSData(NXstatus status, NXhandle fileID, const int pidNum, const int pidStart, float lowerValue, float upperValue);

        void setMonData(NXstatus status, NXhandle fileID, std::string filename,  const int pidNum, const float pc); 
	//void getHistDataFromDrone(string prepath,string moduleName, std::vector<uint32_t> &histData);
        //void getMultiHistData(string prepath,std::vector<uint32_t> &histData);

        //void getHistDataFromDrone(string prepath,string moduleName, std::vector<uint32_t> &histData, string inst);
        //void getEvtDataFromDrone(string prepath,string moduleName, std::vector<int64_t> &pid, std::vector<float> &tof, std::vector<uint64_t> &pulse);
        //void getMultiEvtData(string prepath,std::vector<int64_t> &pid, std::vector<float> &tof, std::vector<uint64_t> &pulse);
        //int getMonitorData(string filename, const int pids, const int tBins, std::vector<uint32_t> &histData);

        //void getMRData(string daqFile, const int pidNum, const int pidStart, const int pidEnd,  const int tofNum, const int tofStart, const int tofEnd, uint64_t& evtNum, std::vector<int64_t> &pid, std::vector<float> &tof, std::vector<uint64_t> &pulse, std::vector<uint32_t> &histData);
        
	//get raw data from ew
        void getSANSData(const vector<string> &daqFile, const int pidNum, const int pidStart,  const int tofNum, const int tofStart, const int tofEnd, std::vector<int64_t> &pid, std::vector<float> &tof, std::vector<uint64_t> &pulse, std::vector<uint32_t> &histData, float lowerValue, float upperValue, int bins);
	//void getGPPDData();

};

#endif
