#include "PMTParser.hh"
#include <vector>
#include <algorithm>

Parser::PMTParser::PMTParser() {}

Parser::PMTParser::~PMTParser() {}

//find the end position of a package
//Function returns true if the end position of a valid package is found
bool Parser::PMTParser::fixStartFindEnd(const uint8_t* const fixedStart, const uint8_t* const stream_end, const uint8_t*& pkgend) const
{
  if(fixedStart>=stream_end)
    return false;

  if(*fixedStart!=0xFA)//start Token
    return false;

  for(uint8_t* pos= const_cast<uint8_t*>(fixedStart)+16; pos<stream_end; pos+=4)
  {
    //if(*pos<0xFB) //all good
    if(*pos==0xFB)
    {
      pkgend = pos + 8;
      return true;
    }
    else if(*pos>0xF0)
    {
      return false; //fixme: should raise error here
    }
  }
  return false;
}


//extract info from next package
bool Parser::PMTParser::extractNextPackage(const uint8_t*& pos, const uint8_t * const stream_end, std::vector<HitInfo>& hitinfo) const
{
  if(stream_end<=pos)
    return false;
  hitinfo.clear();
  const uint8_t *package_end;
  uint64_t offset=0;

  if(!findNextPackageStartEnd(stream_end, pos, package_end, offset))
    return false;

  uint32_t t0(0);
  pos += 8;
  read_uint32(pos, t0);

  //make hitmap of data
  std::vector<uint32_t> hitmap;
  for(pos+=4;pos<package_end;)
  {
    uint32_t data(0);
    read_uint32(pos, data);
    uint32_t tof  = MASK_24 & data;
    if(tof) //skip the padding zero
    {
      uint8_t chn= (data >> 24) & MASK_8;
      hitmap.push_back( (tof<<8) +chn);
    }
  }
  std::sort(hitmap.begin(), hitmap.end());

  return true;
}
