#ifndef PMTParser_hh
#define PMTParser_hh

#include "ParserBase.hh"

namespace EXPORT_SYMBOL Parser {

class PMTParser : public ParserBase {
  PMTParser();
  ~PMTParser() override;

  //find the end position of a package, invoked by findNextPackageStartEnd function in the base
  //Function returns true if the end position of a valid package is found
  bool fixStartFindEnd(const uint8_t* const fixedStart, const uint8_t* const stream_end, const uint8_t*& pkgend) const override ;

  //extract info from next package
  bool extractNextPackage(const uint8_t*& pos, const uint8_t * const stream_end, std::vector<HitInfo>& hitinfo) const override;

};

}

#endif
