#ifndef GPPDSNDRecAlg_h
#define GPPDSNDRecAlg_h
// @(#)DroNE/Algorithms:$Id$
// Authors: H.L. TIAN & B. TANG 2017
/**********************************************************************
 *                                                                    *
 * Copyright (c) 2017 Data Analysis & Instrument Software, CSNS       *
 *                                                                    *
 *                                                                    *
 **********************************************************************/
//
//  GPPDSNDRecAlg.h
//
//
//  Created by Haolai TIAN & Bin TANG 31th May 2017.
//
//

#include <vector>
#include "ParserBase.hh"

class GPPDSNDRecAlg
{
    public:
        GPPDSNDRecAlg();
        ~GPPDSNDRecAlg();
        bool execute(const std::vector<uint32_t>& hitmap);

    private:
	int m_count;

    private: // tangb@ihep.ac.cn
	std::vector<int> m_buffer, m_result;
	void reconstruct(int time);
	int scan(int *Pos,int l,int &ThePosition,int &Real);
	int sort(int *src, int len);
	int calculation(int &X,int &Y,int &Effect);
};

#endif
