#ifndef IncPARSERXML
#define IncPARSERXML

#include <string>
#include <map>
#include <vector>
#include <list>
#include <tinyxml.h>
using namespace std;

struct CSNSgeometry{
        vector<float> ori;
        string shape;
        vector<float> size;
        vector<float> distances;
};

struct CSNSbs{
        CSNSgeometry geometry;
        float distance[3];
        string status;
};
struct CSNSlogs{
        string name;
        vector<string> filePath;
};
struct CSNSfp{
    string name;
    string type;
    float pc;
    int spin;
};

struct CSNSpz{
    string name;
    string type;
    
};

struct CSNSaz{
    string name;
    string usage;
};

class ParserXML {
    public:

        ParserXML(string filename)
        {
            cout<<"start load "<<filename<<endl;
            TiXmlDocument *doc=new TiXmlDocument(filename.c_str());
            doc->LoadFile();
            if (doc==NULL)
                cout<<"error: no such xml file!"<<endl;
            else
                root=doc->RootElement();       
                cout<<"doc for parser xml: "<<doc<<" root: "<<root->Value()<<endl;
        }

    //get info from configure
        map<string, string> getTofInfo_CONF(string nodeName);
        map<string, string> getTHInfo_CONF(string nodeName);
        vector<string> getModuleList_CONF(string detectorName);
        string getPath_CONF(string nodeName);
        string getInstName_CONF();
        map<string, string> getPid_CONF(string moduleName);

    //get info from summary
        map<string, string> getPublic_SUM();
        map<string, string> getModerator_SUM();
        map<string, string> getSource_SUM();
        map<string, string> getSample_SUM();
        map<string, string> getBank_SUM();
        vector<map<string, string> > getAperture_SUM();
        vector<map<string, string> > getSlit_SUM();
        vector<map<string, string> > getDC_SUM();
        vector<map<string, string> > getSE_SUM();
        vector<map<string, string> > getMon_SUM();

        string getBankMode_SUM();
        CSNSgeometry getGeometry(string nodeName);

    // get info from idf
        map<string, string> getModulePos_IDF(string moduleName); 

    private:
        TiXmlElement *root;
        void coutMap(map<string, string> info);

        std::vector<std::string> split(string str, string sep);
        void findNode(TiXmlElement *tree,TiXmlElement * &destNode, const char* nodeName);
        void findNode(TiXmlElement *tree,TiXmlElement * &destNode,const char* nodeName, const char* attrName, const char* attrValue);

        // text value        
        string getTextValue(TiXmlElement *knowNode);
        vector<string> getTextArray(TiXmlElement *knowNode);
        vector<float> findTextArray(TiXmlElement *knowNode, const char* nodeName, int num); 
        float string2float(string name);
        vector<float> vecString2float(const vector<string> &vec, int num);
        map<string, string> getAllSonNodeAndTextValue(TiXmlElement *knowNode);
        //for summary
        map<string, string> getOneComponent(string NXname);
        vector<map<string, string> > getMultiComponent(string NXname, string typeName);

        // attr value
        map<string, string> findAllAttrValues(TiXmlElement *knowNode, const char* nodeName); 
        string getSpecialAttrValue(TiXmlElement *knowNode,const char* attrName);


};

#endif
