#ifndef IncPARSERNXS
#define IncPARSERNXS

#include <string>
#include <map>
#include <vector>
#include <list>
#include <tinyxml.h>
#include "NeXusFile.hpp"


class ParserNXS {
    public:
        ParserNXS(string filepath)
        { nxsfile = filepath;}
        //void getEventData(string daqFileame, uint64_t& evtNum, std::vector<int64_t> &pid, std::vector<float> &tof, std::vector<uint64_t> &pulse);

        //void getEventData(string filename,uint64_t& evtNum, int64_t* pid, float* tof, uint64_t* pulse);  // now this is just for single module
        //void getHistDataFromDrone(string prepath,string moduleName, std::vector<uint32_t> &histData);
        //void getMonitorData(string filename,const int pids, const int tBins, std::vector<uint32_t> &histData);


        //void getHistData(string prepath, string runno, string filename, uint32_t* histData, bool bm);

        void createNXS();
        void setPublic(ParserXML new_xml, string idfFilename); 
        void setInstrument(ParserXML new_xml);
        void setBank(ParserXML conf_xml,ParserXML sum_xml, ParserXML idf_xml, const vector<string> &dataPath);
        void setMonitor(ParserXML conf_xml,ParserXML sum_xml, ParserXML idf_xml, map<string, string> fileList);
        void setHistData(const std::vector<string> &dName); //set link for all module or monitor
        void setEventData(const std::vector<string> &dName); //set link for all module or monitor
        //void setDetector(ParserXML idf_xml, ParserXML conf_xml, const vector<string> & moduleList);
        /*
        void setUser(ParseXML new_xml); //set default value
        void setProcess(); // set default value
        void setPresentData(const int timeBin, const int timeStep); // set random value
        */
    private:
        string nxsfile;
        std::vector<std::string> split(string str, string sep);
        void coutMap(map<string, string> info);
        string int2string(int num);
        bool judgeVector(const vector<map<string, string> > &data);
        bool judgeMap(map<string, string> data);


        //int xpids;
        //int ypids;
        //int pidStart;
        //int timeBin;
        //int timeStep;
        //int timeStart;

        void writeGroup(NXstatus status, NXhandle fileID, const char* groupName, const char* groupType);
        void writeCharData(NXstatus status, NXhandle fileID, const std::string dataName, const std::string dataValue);
        void writeNumData(NXstatus status, NXhandle fileID, const std::string dataName, const float* dataValue, int dimension, int dim[], std::string text);
        void writeNumData(NXstatus status, NXhandle fileID, const std::string dataName, const int64_t* dataValue, int dimension, int dim[], std::string text);
        void writeNumData(NXstatus status, NXhandle fileID, const std::string dataName, const uint64_t* dataValue, int dimension, int dim[], std::string text);
        void writeNumData(NXstatus status, NXhandle fileID, const std::string dataName, const uint32_t* dataValue, int dimension, int dim[], std::string text);
        void writeSlabData(NXstatus status, NXhandle fileID, const std::string dataName, const float* dataValue, int dim[], int slab_start[], int slab_size[], std::string text);
        void writeSlabData(NXstatus status, NXhandle fileID, const std::string dataName, const int64_t* dataValue, int dim[], int slab_start[], int slab_size[], std::string text);
        void writeSlabData(NXstatus status, NXhandle fileID, const std::string dataName, const uint32_t* dataValue, int dim[], int slab_start[], int slab_size[], std::string text);
        
        string getStringFromMap(const map<string, string> data, string name);
        float getFloatFromMap(const map<string, string> data, string name);
        int getIntFromMap(const map<string, string> data, string name);
        map<string, string> getMapFromVector(const vector<map<string, string> >& data, string keyword, string value);


        void setModerator(NXstatus status, NXhandle fileID, map<string, string> info);
        void setSource(NXstatus status, NXhandle fileID, map<string, string> info);
        void setSample(NXstatus status, NXhandle fileID, map<string, string> info);
        void setDC(NXstatus status, NXhandle fileID, const vector<map<string, string>>& info);
        void setSE(NXstatus status, NXhandle fileID, const vector<map<string, string>>& info); 
        void setAperture(NXstatus status, NXhandle fileID, const vector<map<string, string>>& info, string name, string typeName);
        //void setGeometry(NXstatus status, NXhandle fileID, CSNSgeometry info);
        void setGeometry(NXstatus status, NXhandle fileID, string path, CSNSgeometry info);

        void setPid(NXstatus status, NXhandle fileID, int idstart, const int xpid, const int ypid);
        void setPidSize(NXstatus status, NXhandle fileID, float xstep,float ystep, const int xpid, const int ypid);
        void setCoordinate(NXstatus status, NXhandle fileID,float xpos, float ypos, float zpos, float xstep, float ystep, float rotValue, const int xpid, const int ypid);
        void setTof(NXstatus status, NXhandle fileID,const int tStart, const int tBin, const int tStep, const uint32_t delay);
        void getHistDataFromDrone(string prepath,string moduleName, std::vector<uint32_t> &histData);
        void getMultiHistData(string prepath,std::vector<uint32_t> &histData);

        //void getHistDataFromDrone(string prepath,string moduleName, std::vector<uint32_t> &histData, string inst);
        void getEvtDataFromDrone(string prepath,string moduleName, std::vector<int64_t> &pid, std::vector<float> &tof, std::vector<uint64_t> &pulse);
        void getMultiEvtData(string prepath,std::vector<int64_t> &pid, std::vector<float> &tof, std::vector<uint64_t> &pulse);
        void getMonitorData(string filename, const int pids, const int tBins, std::vector<uint32_t> &histData);

        void getMRData(string daqFile, const int pidNum, const int pidStart, const int pidEnd,  const int tofNum, const int tofStart, const int tofEnd, uint64_t& evtNum, std::vector<int64_t> &pid, std::vector<float> &tof, std::vector<uint64_t> &pulse, std::vector<uint32_t> &histData);
        
        void getSANSData(const vector<string> &daqFile, const int pidNum, const int pidStart,  const int tofNum, const int tofStart, const int tofEnd, std::vector<int64_t> &pid, std::vector<float> &tof, std::vector<uint64_t> &pulse, std::vector<uint32_t> &histData, float lowerValue, float upperValue, int bins);


};

#endif
