#ifndef EwMonitor_hh
#define EwMonitor_hh

#include <vector>
#include <mutex>
#include <memory>
#include <chrono>
#include <string>
#include <atomic>
#include "NumpyHist2D.hh"

class neutronClientStartMonitor;
class NeutronPulseData;
class EwMonitor {
public:
  EwMonitor(std::string monitorName, unsigned numtof, double tofLower, double tofUpper, unsigned numPix, double pLower, double pUppder);
  ~EwMonitor();

  void start();
  void stop();
  void clear();
  void fill(double tof, double pid);
  const NumpyHist2D& getHist(){return hist2d;}
private:
  mutable std::mutex m_monitor_mutex;
  // std::chrono::milliseconds m_intvl_ms;
  std::atomic<bool> m_active;
  neutronClientStartMonitor *m_dron_monitor; // this is the class used in DroNE
  NumpyHist2D hist2d;
};



#endif
