#include <dic.hxx>
#include <iostream>
#include <vector>
#include <string>
#include <fstream>
#include <memory>
#include <chrono>
#include <future>
#include <nlohmann/json.hpp>

#include "DAQInterface.hh"
#include "Hist2DMap.hh"
#include "RedisIO.hh"
#include "Earthworm.hh"
#include "RedisNumpy.hh"
#include "MyStateMachine.hh"

#include "Action_MR.hh"

int main()
{
	std::cout << "Starting client..." << std::endl;


	//redis should retrive all parameters

	RedisIO *redis = new RedisIO(9001, "neonmaster", "sanlie;123");
	MyStateMachine *sMachine = new MyStateMachine();
  Action_MR *action = new Action_MR(redis, sMachine);

	sMachine->grantStateTransit(State::kUnconfigured, State::kReady, Command::kConfigure, std::bind( &Action_MR::configure, action), "configure");
  sMachine->grantStateTransit(State::kReady, State::kUnconfigured, Command::kUnconfigure, std::bind( &Action_MR::unconfigure, action), "unconfigure");
	sMachine->grantStateTransit(State::kReady, State::kUnconfigured, Command::kAbort, std::bind( &Action_MR::unconfigure, action), "unconfigure");

  sMachine->grantStateTransit(State::kReady, State::kRunning, Command::kStart, std::bind( &Action_MR::start, action), "start");
  sMachine->grantStateTransit(State::kRunning, State::kReady, Command::kStop, std::bind( &Action_MR::pauseStop, action), "pauseStop");
  sMachine->grantStateTransit(State::kRunning, State::kPaused, Command::kPause, std::bind( &Action_MR::pauseStop, action), "pauseStop");
  sMachine->grantStateTransit(State::kPaused, State::kRunning, Command::kResume, std::bind( &Action_MR::resume, action), "resume");
  sMachine->grantStateTransit(State::kRunning, State::kUnconfigured, Command::kAbort, std::bind( &Action_MR::unconfigure, action), "unconfigure");
  sMachine->grantStateTransit(State::kPaused, State::kUnconfigured, Command::kAbort, std::bind( &Action_MR::unconfigure, action), "unconfigure");
	sMachine->grantStateTransit(State::kRunning, State::kRunning, Command::kStart, std::bind( &Action_MR::keepRunning, action), "keepRunning");
	sMachine->grantGlobalTransitTo(State::kError, Command::kKill, std::bind( &Action_MR::kill, action), "kill");


  //selfDiagnosis() generates 10k state and command in random combination,
  //and record those in fact can change the state
  sMachine->selfDiagnosis();

	while(sMachine->getState()!=State::kError)
	{
		std::this_thread::sleep_for(std::chrono::milliseconds(1000));
		action->update();
		action->sendHeartbeat(false);
  }

  delete redis;
	delete sMachine;
	delete action;

	EW_LOG_INFO("Earthworm_mr is exiting...");
  return 0;
}
