#include "RunStatus.hh"
#include <unistd.h>  //getpid
#include <nlohmann/json.hpp>
#include "Earthworm.hh"
#include <ctime>

RunStatus::RunStatus(const std::shared_ptr<RedisIO> &r,
const std::string &cmdpath, const std::string &hbpath )
:m_redis(std::shared_ptr<RedisIO>(r))
,m_cmdPath(cmdpath), m_heartBeatPath(hbpath)
,m_status(RunStatus::Status::kWaiting)
,m_proID(getpid())
{


}

RunStatus::~RunStatus()
{

}


RunStatus::Status RunStatus::update()
{
  int reply = m_redis->readInt(m_cmdPath);
  if(reply==0) //configure
    m_status = Status::kReady;
  else if(reply==2) //start
    m_status = Status::kRunning;
  else if(reply==5) //stop
    m_status = Status::kReady;
  else if(reply==6) //abort
    m_status = Status::kUnconfigured;
  else
    EW_LOG_CRITICAL("unknow command \"{}\" received from cockpit. Earthworm status is unchanged.", reply);

  return m_status;
}


std::string RunStatus::genHeartBeat()
{
  nlohmann::json j;
  j["pid"] = m_proID;

  if(m_status==Status::kReady)
    j["status"] = "reday";
  else if(m_status==Status::kRunning)
    j["status"] = "running";
  else if(m_status==Status::kUnconfigured)
    j["status"] = "unconfigured";
  else if(m_status==Status::kWaiting)
    j["status"] = "waiting";
  else
    EW_LOG_CRITICAL("Unsupported status");

  std::time_t t = std::time(nullptr);
  char mbstr[100];
  if (std::strftime(mbstr, sizeof(mbstr), "%Y-%m-%dT%H:%M:%S.%03d+08:00", std::localtime(&t))) {
      std::cout << mbstr << '\n';
  }
  std::string timestr (mbstr);
  std::cout << timestr << '\n';
  j["timestamp"] = timestr;

  return j.dump();
}
