#include <string>
#include "RedisIO.hh"

class RunStatus {
public:
	enum Status {
    kWaiting,
    kUnconfigured,
    kConfiguring,
    kReady,
    kRunning,
    kPaused,
    kError
    };
  enum Command {
    kConfigure,
    kUnconfigure,
    kStart,
    kPause,
    kResume,
    kStop,
    kAbort
  };

public:
	RunStatus(const std::shared_ptr<RedisIO> &r, const std::string &cmdpath, const std::string &hbpath );
	~RunStatus();

  Status update();
  std::string genHeartBeat();

private:
  std::shared_ptr<RedisIO> m_redis;
  const std::string m_cmdPath, m_heartBeatPath;
  Status m_status;
  unsigned m_proID;

};
