#include <cstdio>
#include <fstream>
#include <vector>
#include <string>
#include <iostream>
#include <fstream>
#include <omp.h>


#include "ParserUtils.hh"
#include "PMTParser.hh"
#include "NumpyHist2D.hh"
#include "FileSysHelper.hh"

int main(int argc, char *argv[])
{
  //read data
  // std::string fname = "module44_t0220_bug.dat";
  // std::string fname = "RUN0001225/BL18_RUN0001225_MODULE44_FILE001_20190316212625.dat";

 //  std::vector<std::string> files {"BL18_RUN0001225_MODULE02_FILE001_20190316212625.dat", "BL18_RUN0001225_MODULE24_FILE001_20190316212625.dat",
 // "BL18_RUN0001225_MODULE03_FILE001_20190316212625.dat", "BL18_RUN0001225_MODULE25_FILE001_20190316212625.dat",
 // "BL18_RUN0001225_MODULE04_FILE001_20190316212625.dat", "BL18_RUN0001225_MODULE27_FILE001_20190316212625.dat",
 // "BL18_RUN0001225_MODULE05_FILE001_20190316212625.dat", "BL18_RUN0001225_MODULE28_FILE001_20190316212625.dat",
 // "BL18_RUN0001225_MODULE06_FILE001_20190316212625.dat", "BL18_RUN0001225_MODULE29_FILE001_20190316212625.dat",
 // "BL18_RUN0001225_MODULE07_FILE001_20190316212625.dat", "BL18_RUN0001225_MODULE30_FILE001_20190316212625.dat",
 // "BL18_RUN0001225_MODULE08_FILE001_20190316212625.dat", "BL18_RUN0001225_MODULE31_FILE001_20190316212625.dat",
 // "BL18_RUN0001225_MODULE09_FILE001_20190316212625.dat", "BL18_RUN0001225_MODULE32_FILE001_20190316212625.dat",
 // "BL18_RUN0001225_MODULE10_FILE001_20190316212625.dat", "BL18_RUN0001225_MODULE33_FILE001_20190316212625.dat",
 // "BL18_RUN0001225_MODULE11_FILE001_20190316212625.dat", "BL18_RUN0001225_MODULE34_FILE001_20190316212625.dat",
 // "BL18_RUN0001225_MODULE12_FILE001_20190316212625.dat", "BL18_RUN0001225_MODULE35_FILE001_20190316212625.dat",
 // "BL18_RUN0001225_MODULE13_FILE001_20190316212625.dat", "BL18_RUN0001225_MODULE36_FILE001_20190316212625.dat",
 // "BL18_RUN0001225_MODULE14_FILE001_20190316212625.dat", "BL18_RUN0001225_MODULE37_FILE001_20190316212625.dat",
 // "BL18_RUN0001225_MODULE15_FILE001_20190316212625.dat", "BL18_RUN0001225_MODULE38_FILE001_20190316212625.dat",
 // "BL18_RUN0001225_MODULE16_FILE001_20190316212625.dat", "BL18_RUN0001225_MODULE39_FILE001_20190316212625.dat",
 // "BL18_RUN0001225_MODULE17_FILE001_20190316212625.dat", "BL18_RUN0001225_MODULE40_FILE001_20190316212625.dat",
 // "BL18_RUN0001225_MODULE18_FILE001_20190316212625.dat", "BL18_RUN0001225_MODULE42_FILE001_20190316212625.dat",
 // "BL18_RUN0001225_MODULE19_FILE001_20190316212625.dat", "BL18_RUN0001225_MODULE43_FILE001_20190316212625.dat",
 // "BL18_RUN0001225_MODULE20_FILE001_20190316212625.dat", "BL18_RUN0001225_MODULE44_FILE001_20190316212625.dat",
 // "BL18_RUN0001225_MODULE21_FILE001_20190316212625.dat", "BL18_RUN0001225_MODULE45_FILE001_20190316212625.dat",
 // "BL18_RUN0001225_MODULE22_FILE001_20190316212625.dat", "BL18_RUN0001225_MODULE23_FILE001_20190316212625.dat"};

  std::vector<std::string> files {"BL18_RUN0001225_MODULE44_FILE001_20190316212625.dat"};

  // std::vector<std::string> files {"../pmt_benckmark.dat"};
  std::sort(files.begin(), files.end());

  #pragma omp parallel for firstprivate(files)
  for(unsigned i=0;i<files.size();i++)
  {
    FileReader reader("RUN0001225/"+files[i]);
    std::vector<uint8_t> data;
    reader.readAll(data);
    const uint8_t * buffer = data.data();
    const size_t length = reader.fileLength();

    auto *pmt = new Parser::PMTParser();
    std::vector<Parser::HitInfo> hitinfo;
    unsigned loop=0, event_cnt = 0;

    // NumpyHist1D hist_pid (1344,-0.5,1344-0.5);
    // NumpyHist1D hist_tof (2500,0,16*2500);
    NumpyHist2D hist( 2500*4, 0., 16*2500, 5328, 0.-0.5, 5328-0.5);
    double digit2us = 1./40;

    for(unsigned i=0;i<1;i++)
    {
      const uint8_t * abuf = buffer;
      while(pmt->extractNextPackage(abuf, buffer+length, hitinfo))
      {
        loop++;
        event_cnt+=hitinfo.size();
        for(auto v: hitinfo)
        {
          unsigned pid = pmt->getPixelID((int)v.pos, (int)v.posy, true);

          hist.fill( (int)(v.t/40), pid);
          printf("%d;%d;%d\n", (int)pid, (int)(v.t)/40, (int)v.hit_t0 );
        }
      }
    }
    // auto s=files[i].find("MODULE");
    // std::string idx = files[i].substr(s,8);
    // std::string saveAs = "run1225/hist_"+idx+".pyn";
    // hist.save(saveAs);
    // printf("%s, %s, %d \n", files[i].c_str(), saveAs.c_str(), event_cnt);
   }
   return 0;
}
