#!/usr/bin/python

from __future__ import print_function
import vacf
import time
import sys
import h5py
import numpy as np
import matplotlib.pyplot as plt
from xlib import *

radpsec2meV =  6.5821e-13
radpfs2meV = radpsec2meV*1e15

fname = 'dump_h5md_small.h5'
if len(sys.argv)==2:
    fname = sys.argv[1]

trj = Trajectory(fname)
print ('getAtomType', trj.getAtomType())

rSpacingInAa, tSpacingInfs, rScalefact, gtr = trj.gtr(1,1,15.,1000)

rRange = np.arange(gtr.shape[1]) *  rSpacingInAa
tRange = np.arange(gtr.shape[0]) *  tSpacingInfs

# print('rSize', rSize)
# print('tSize', tSize)
###Gtr
idx = [1, 10, 67, 67*2 ,67*2**2, 67*2**3]
for i in idx:
    #plt.plot(spaRange,  gtr[:,i], label = str(tSpacingInfs*i)+'fs')
    plt.plot(rRange, rScalefact * gtr[i,:], label = str(tRange[i])+'fs')
    print('Integral ', np.trapz(rScalefact * gtr[i,:], rRange))
plt.xlabel('R, Aa')
plt.legend()
plt.title('Gr mult by 4pi*r*r')

####cvv
start_time = time.time()
cvv = trj.cvv(1,1)
print  ('time ' , time.time() - start_time, 's')

print (cvv)
# plt.plot(cvv)
plt.figure()
en, dos = trj.fftReal(cvv, trj.deltaTfs , 2*np.pi * radpfs2meV )
plt.plot(en, dos)
plt.legend()


#
# #  intermediate
timeStep=np.arange(0,trj.nFrame//2,200,dtype=np.uint32)
print('timeStep',  timeStep)
Q=np.logspace(-1,1.6,20)

start_time = time.time()
ftq_hh=trj.intermediate(1, 1,  Q, timeStep)
print  ('time ' , time.time() - start_time, 's')

for res, aq in zip(ftq_hh.T, Q):
    plt.semilogx(timeStep*trj.getDeltaT()*1e-3, res, 'o', label='Q='+str(aq))

# print(FsTQ)
dataabe=np.loadtxt('abe2015fig1.dat')
plt.semilogx(dataabe[:,0],dataabe[:,1], zorder=100, label='Q=1.6A^-1')

plt.legend()
plt.xlabel('time, ps')
plt.ylabel('Fs(Q,t)')

plt.show()
