#include <dic.hxx>
#include <iostream>
#include <vector>
#include <string>
#include <fstream>
#include <memory>

#include "DAQInterface.hh"
#include "Hist2DMap.hh"
#include "RedisIO.hh"
#include "Earthworm.hh"
#include "RedisNumpy.hh"

int main()
{
	// int cmd = rio.readInt("/SANS/control/command/drone");
	// std::cout << cmd << '\n';
	// EW_LOG_INFO("cmd is {}", cmd);
	//
	// std::string detconf = rio.readString("/MR/control/configure");
	// //  _configure['mode']
	// EW_LOG_INFO("detconf is {}", detconf);
	//
	// //std::string s = j.dump();    // {\"happy\":true,\"pi\":3.141}
	//
	//
	// auto j = nlohmann::json::parse(detconf);
	// std::string mode = j["mode"];
	// EW_LOG_INFO("det is {}", mode);
	//
	//
	// abort();

	std::cout << "Starting client..." << std::endl;
  unsigned pid_num(5328), tof_num(2500);

	std::shared_ptr<NumpyHist2D> hist (new NumpyHist2D(tof_num, 0., tof_num*16, pid_num, 0.-0.5, pid_num-0.5));

  //RunNumber runNumber;
	DAQInterface *daq =  new DAQInterface("shenme/shenme",1000);
	daq->setActive(true);
  daq->setHist2D(hist);

	auto start = std::chrono::steady_clock::now();


	unsigned loop=10;
	while(loop)
	{
		std::this_thread::sleep_for(std::chrono::milliseconds(1000));
		loop--;
    std::string str;

		//histmap->merge(str);
		//redis->writeString("/sim/MR/workspace/detector/module1/value", str);
    EW_LOG_INFO("Data integral {}", hist->getIntegral());
	}
	
	if( hist->getIntegral()) {
		hist->save("rebin.pyn");
	}


	EW_LOG_INFO("overflow {}, underflow {}", hist->getOverflow(), hist->getUnderflow());


	double t=std::chrono::duration_cast<std::chrono::seconds>(std::chrono::steady_clock::now()
	             - start).count();
  std::cout << "speed is "  << t/100 << "s per loop\n"
	<< hist->getIntegral()/t << "event/s \n";
  if(daq)	delete daq;
  return 0;
}
