#include "RedisIO.hh"
#include "Earthworm.hh"
#include <chrono>
#include <thread>
#include <nlohmann/json.hpp>
#include "RedisHelper.hh"
// this example writes an incremental double array to a Redis storage and read back.
int main(void) {
  //IP and account are in the IHEP network

  RedisIO rio( 9001, "neonmaster", "sanlie;123");

  std::vector<double> data;
  unsigned sz = 20;
  data.reserve(sz);
  for(unsigned i=0;i<sz;i++)
    data.push_back(i);

  uint8_t* rawData = reinterpret_cast<uint8_t*>(data.data());
  std::string dataAsString(rawData, rawData+sz*sizeof(double) );

  for(unsigned i=0;i<1000;i++)
  {
    rio.writeString("/XX/dont/touch/me", dataAsString);
    //std::this_thread::sleep_for(std::chrono::milliseconds ( 2000 ));
    std::string readback = rio.readString("/XX/dont/touch/me");
    if(dataAsString!=readback)
      EW_LOG_INFO("Data corrupted");
    else
      EW_LOG_INFO("Data are successfully transceived ");
  }

  // const double *uintarr = reinterpret_cast<const double *>(readback.data());
  // for(unsigned i=0;i<sz;i++)
  //   printf("%f\n",*(uintarr+i) );


  return 0;
}
