#include "PMTParser.hh"
#include <vector>
#include <fstream>

Parser::PMTParser::PMTParser():ParserBase(), m_reconst() ,
m_strPix(std::map<unsigned, unsigned>{{43, 1230001}, {20, 1310001}, {38, 1320001}, {26, 1330001}, {36, 1410001}, {39, 1420001}, {42, 1430001}, {44, 2210001}, {32, 2310001}, {7, 2320001}, {30, 2330001}, {41, 2410001}, {19, 2420001}, {34, 2430001}, {10, 3220001}, {1, 3310001}, {3, 3320001}, {4, 3330001}, {11, 3410001}, {37, 3420001}, {8, 3430001}, {29, 4220001}, {13, 4310001}, {5, 4320001}, {16, 4330001}, {2, 4410001}, {18, 4420001}, {21, 4430001}, {31, 5210001}, {6, 5310001}, {12, 5320001}, {17, 5330001}, {23, 5410001}, {22, 5420001}, {35, 5430001}, {14, 6230001}, {24, 6310001}, {15, 6320001}, {27, 6330001}, {33, 6410001}, {28, 6420001}, {9, 6430001}} )
{m_moduleID=0;}

Parser::PMTParser::~PMTParser() {}

//find the end position of a package
//Function returns true if the end position of a valid package is found
bool Parser::PMTParser::fixStartFindEnd(const uint8_t* const fixedStart, const uint8_t* const stream_end, const uint8_t*& pkgend) const
{
  if(fixedStart>=stream_end)
    return false;

  if(*fixedStart!=0xFA)//start Token
    return false;

  for(uint8_t* pos= const_cast<uint8_t*>(fixedStart)+16; pos<stream_end; pos+=4)
  {
    //if(*pos<0xFB) //all good
    if(*pos==0xFB)
    {
      pkgend = pos + 8;
      return true;
    }
    else if(*pos>0xF0)
    {
      printf("Channel number greater than 0xF0");
      return false; //fixme: should raise error here
    }
  }
  return false;
}

uint64_t Parser::PMTParser::getPixelID(unsigned x, unsigned y)
{
	return m_strPix.find(m_moduleID)->second + (uint64_t(y/4)*111+uint64_t(x/4));
}


//extract info from next package
bool Parser::PMTParser::extractNextPackage(const uint8_t*& pos, const uint8_t * const stream_end, std::vector<HitInfo>& hitinfo) const
{
  if(stream_end<=pos)
    return false;
  hitinfo.clear();
  const uint8_t *package_end;
  uint64_t offset=0;

  if(!findNextPackageStartEnd(stream_end, pos, package_end, offset))
    return false;

  // printf("full package \n");
  // for(auto it=pos;it!=package_end;++it)
  // {
  //   printf("%d ", *it);
  //   if((it-pos+1)%4==0 && it-pos>2)
  //     printf("\n");
  // }
  // printf("\n");
  // abort();

  uint32_t t0(0);
  m_moduleID = *(pos+3);
  pos += 8;
  read_uint32(pos, t0);

  // if(t0==220)
  // {
  //   const uint8_t *aa = pos-12;
  //   printf("full package \n");
  //   for(auto it=aa;it!=package_end;++it)
  //   {
  //     printf("0x%x ", *it);
  //     if((it-aa+1)%4==0 && it-aa>2)
  //       printf("\n");
  //   }
  //   printf("\n");
  //
  //   std::ofstream myFile ("module44_t0220_bug.dat", std::ios::out | std::ios::binary);
  //   myFile.write (reinterpret_cast<const char*>(aa), package_end-(pos-12));
  //   myFile.close();
  // }


  //make hitmap of data
  std::vector<uint32_t> hitmap;
  for(pos+=4;pos<package_end-8;)
  {
    uint32_t data(0);
    read_uint32(pos, data);
    uint32_t tof  = MASK_24 & data;
    if(tof) //skip the padding zero
    {
      uint8_t chn= (data >> 24) & MASK_8;
      hitmap.push_back( (tof<<8) +chn);
    }
  }
  // no more reading after here, set pointer to the start of next package
  pos = package_end;

  std::sort(hitmap.begin(), hitmap.end());

  // if(t0==220)
  // {
  //   printf("tof(us);channel\n");
  //   for(auto v: hitmap)
  //   {
  //     printf("%g;%d\n", ((v>>8) & MASK_24)/40., v&MASK_8);
  //   }
  //   abort();
  //
  // }

  // m_reconst.execute(hitmap);
  // return true;

  //reconstruction
  int time=0;
  int timeleap=0;
  std::vector<uint32_t> chlBuf;
  for(uint32_t i = 0; i < hitmap.size(); i++)
  {
    if(0==i)
    {
      chlBuf.clear();
      chlBuf.push_back(hitmap[i]&MASK_8);
      time = (hitmap[i]>>8) & MASK_24;
    }
    else
    {
      timeleap = time - ((hitmap[i]>>8) & MASK_24);
      timeleap = abs(timeleap);
      if(80>timeleap)
      {
        chlBuf.push_back(hitmap[i]&MASK_8);
      }
      else
      {
        reconstruct(chlBuf,hitinfo, time, t0);
        chlBuf.clear();
        chlBuf.push_back(hitmap[i]&MASK_8);
      }
      time = (hitmap[i]>>8) & MASK_24;
    }
  }
  // the last hit
  if(!chlBuf.empty()) {
    reconstruct(chlBuf,hitinfo, time, t0);
  }

  return true;
}
