#include "RunStatus.hh"
#include <unistd.h>  //getpid
#include <nlohmann/json.hpp>
#include "Earthworm.hh"
#include <ctime>

RunStatus::RunStatus(const std::shared_ptr<RedisIO> &r,
const std::string &cmdpath, const std::string &hbpath )
:StateMachine(1), m_redis(std::shared_ptr<RedisIO>(r))
,m_cmdPath(cmdpath), m_heartBeatPath(hbpath)
,m_proID(getpid())
{

}

RunStatus::~RunStatus()
{

}

RunStatus::Status RunStatus::update()
{
  int reply = atoi(m_redis->readString(m_cmdPath).c_str());
  // int reply = m_redis->readString(m_cmdPath);

  if(reply==0) //configure detector type and reset buffer
    m_status = Status::kConfiguring;
  else if(reply==2) //start accumulate data (RESET AGAIN HERE)
    m_status = Status::kRunning;
  else if(reply==3) //paused fill histogram, still receiving dim datastream but unprocessed
    m_status = Status::kPaused;
  //(kResume)
  else if(reply==5) //stop, reset everythin (NOT RESET,  still receiving dim datastream but unprocessed)
     m_status = Status::kConfiguring; //(start/unconfigure)
  else if(reply==6) //abort
    m_status = Status::kError; //this status will not send vis heartbeat
  else
  {
    EW_LOG_CRITICAL("unknow command \"{}\" received from cockpit. Earthworm status is unchanged.", reply);
  }

  return m_status;
}


std::string RunStatus::genHeartBeat() const
{
  nlohmann::json j;
  j["pid"] = m_proID;

  if(m_status==Status::kUnconfigured)
    j["status"] = "unconfigured";
  else if(m_status==Status::kReady)
      j["status"] = "ready";
  else if(m_status==Status::kRunning)
    j["status"] = "running";
  else if(m_status==Status::kPaused)
    j["status"] = "paused";
  else if(m_status==Status::kError)
    j["status"] = "error";
  else
    EW_LOG_CRITICAL("Unsupported status");

  std::time_t t = std::time(nullptr);
  char mbstr[100];
  if (std::strftime(mbstr, sizeof(mbstr), "%Y-%m-%dT%H:%M:%S.%03d+08:00", std::localtime(&t))) {
  }

  j["timestamp"] = std::string (mbstr);
  return j.dump();
}

void RunStatus::sendHeartBeat() const
{
  m_redis->writeString(m_heartBeatPath,genHeartBeat());
}
