#include <dic.hxx>
#include <iostream>
#include <vector>
#include <string>
#include <fstream>
#include <memory>

#include <nlohmann/json.hpp>

#include "DAQInterface.hh"
#include "Hist2DMap.hh"
#include "RedisIO.hh"
#include "Earthworm.hh"
#include "RedisNumpy.hh"
#include "RunStatus.hh"

int main()
{
	std::cout << "Starting client..." << std::endl;
  unsigned pid_num(1200), tof_num(2500);

	Hist2DMap::DetectorType detType = Hist2DMap::DetectorType::kUnknown;

	std::string prefix = "/sim";
	std::string cmdPath = prefix+"/MR/control/command/earthworm";
  std::string hbpath = prefix + "/MR/heartbeat/earthworm"; //heartbeat
	std::string mrconfPath = prefix+"/MR/control/configure";


  //dim and hist
	std::string dimAddr = prefix+"/dimserver/TEST_SWAP_1";
  std::string pidPath = prefix + "/MR/workspace/detector/module1/pid";
	std::string tofbinPath = prefix + "/MR/workspace/detector/module1/tof";
	std::string detHistPath = prefix + "/MR/workspace/detector/module1/value";


	std::string mwpcDetCntPath = prefix + "/MR/earthworm/detector_counts";
  std::string he3DetCntPath = prefix + "/MR/earthworm/detector_counts_tube";

  std::string protonChargePath = prefix + "/MR/earthworm/proton_charge";
  std::string moniPath = prefix +	"/MR/earthworm/monitor_counts";
	std::string pulsePath = prefix + "/MR/earthworm/pulse_counts";


	std::shared_ptr<RedisIO> redis(
		new RedisIO("10.1.31.116", 9001, "neonmaster", "sanlie;123"));
  //redis should retrive all parameters
  std::shared_ptr<Hist2DMap> histmap(new Hist2DMap(pid_num, 0, 300, tof_num, 0 , 40000 , Hist2DMap::DetectorType::kHe3) );
	std::shared_ptr<RunStatus> status (new RunStatus(redis,cmdPath,hbpath));

  //RunNumber runNumber;
	DAQInterface daq(dimAddr,100);
  daq.setHist2DMap(histmap);

	std::vector<double> pid;
	for(unsigned i=0;i<pid_num;i++)
	  pid.push_back(i+1);
	RedisNumpy nvt;
  std::string pidstr;
	std::vector<uint64_t> shape;
	shape.push_back(pid_num);
	nvt.makeNumpyArr(pid, RedisNumpy::data_type::f8,
									 shape, pidstr);
	redis->writeString(pidPath, pidstr);

	std::vector<double> tof;
	for(unsigned i=0;i<tof_num+1;i++)
	{
		tof.push_back(i*16);
	}
	std::string tofstr;
	shape[0]=(tof_num+1);
	nvt.makeNumpyArr(tof, RedisNumpy::data_type::f8,
									 shape, tofstr);
	redis->writeString(tofbinPath, tofstr);

	RunStatus::Status lastStatus=RunStatus::Status::kUnconfigured;

 EW_LOG_INFO("Waiting for configuration command");
  while(true)
	{
		status->sendHeartBeat();
		auto st = status->update();
		if(st==RunStatus::Status::kConfiguring)
		//start configuration, reset buffers
		{
			EW_LOG_INFO("Initialization");

			std::string conf = redis->readString(mrconfPath);
			auto j =	nlohmann::json::parse(conf);
			std::string dt= j["mode"];
			EW_LOG_INFO("Instrument active detector is {}", dt);

			if(dt=="He3")
				detType=Hist2DMap::DetectorType::kHe3;
			else if(dt=="MWPC")
				detType=Hist2DMap::DetectorType::kMWPC;
			histmap->reset();

			daq.setActiveStatus(false);
			// status->setStatus(RunStatus::Status::kReady);
			EW_LOG_INFO("Ready");

			lastStatus = st;
		  break;
		}

		std::this_thread::sleep_for(std::chrono::milliseconds(100));
	}

	while(lastStatus!=RunStatus::Status::kError)
	{
		//heart beat
		status->sendHeartBeat();
		RunStatus::Status sts = status->update();

		std::this_thread::sleep_for(std::chrono::milliseconds(800));


		if(sts==lastStatus) //unchanged status
		{
			if(sts==RunStatus::Status::kRunning) //keep updating data to redis
			{
				EW_LOG_INFO("Running");

				//hist
		    std::string str;
				histmap->makeNumpyRaw(str,std::vector<unsigned>{7,8,9,11});
				redis->writeString(detHistPath, str);

				if(detType==Hist2DMap::DetectorType::kHe3)
					  redis->writeInt(he3DetCntPath, histmap->getIntegral());
				else if(detType==Hist2DMap::DetectorType::kMWPC)
					  redis->writeInt(mwpcDetCntPath, histmap->getIntegral());
				else
				  EW_LOG_CRITICAL("Detector type is unconfigured!");

				EW_LOG_INFO("Data integral {}", histmap->getIntegral());
			}
			else
			{
				continue;
			}
		}
		else  //changed status
		{
			if(sts==RunStatus::Status::kConfiguring)//start configuration, reset buffers
			{
					EW_LOG_INFO("Reconfiguring, resetting buffer");

					std::string conf = redis->readString(mrconfPath);
				  auto j =	nlohmann::json::parse(conf);
					std::string dt= j["mode"];
					EW_LOG_INFO("Instrument active detector is {}", dt);

					if(dt=="He3")
					  detType=Hist2DMap::DetectorType::kHe3;
					else if(dt=="MWPC")
					  detType=Hist2DMap::DetectorType::kMWPC;
					histmap->reset();

					daq.setActiveStatus(false);
					// status->setStatus(RunStatus::Status::kReady);
					EW_LOG_INFO("Ready");

			}
			else if(sts==RunStatus::Status::kRunning) //start updating data to redis
			{
   			EW_LOG_INFO("Strart running");
				daq.setActiveStatus(true);
			}
			else if (sts==RunStatus::Status::kPaused)//kPaused
			{
				EW_LOG_INFO("Pausing ");
				daq.setActiveStatus(false);

			}
			// else if (sts==RunStatus::Status::kStop)//stop and reset everything
			// {
			// 	EW_LOG_INFO("Stop running and reset accumulated data");
			// 	histmap->reset();
			// 	daq.setActiveStatus(false);
			// }
			else if(sts==RunStatus::Status::kError) //kError
			{
				daq.setActiveStatus(false);
			}

			lastStatus = sts;
		}

	}

	// std::this_thread::sleep_for(std::chrono::milliseconds(100));
  return 0;
}
