#include "StateMachine.hh"

using Status=StateMachine::Status;
using Command=StateMachine::Command;

int main()
{
  StateMachine sm;
  //Define 9 allowed state transit
  //void grantStatusTransit(Status from, Status to, Command byCommand);
  sm.grantStatusTransit(Status::kUnconfigured, Status::kReady, Command::kConfigure);
  sm.grantStatusTransit(Status::kReady, Status::kUnconfigured, Command::kUnconfigure);
  sm.grantStatusTransit(Status::kReady, Status::kRunning, Command::kStart);
  sm.grantStatusTransit(Status::kRunning, Status::kReady, Command::kStop);
  sm.grantStatusTransit(Status::kRunning, Status::kPaused, Command::kPause);
  sm.grantStatusTransit(Status::kPaused, Status::kRunning, Command::kResume);
  sm.grantStatusTransit(Status::kReady, Status::kError, Command::kAbort);
  sm.grantStatusTransit(Status::kRunning, Status::kError, Command::kAbort);
  sm.grantStatusTransit(Status::kPaused, Status::kError, Command::kAbort);

  //selfDiagnosis() generates 10k state and command in random combination,
  //and record those in fact can change the state
  sm.selfDiagnosis();
  return 0;
}
