#ifndef Parser_PackageHe3PosCorr_hh
#define Parser_PackageHe3PosCorr_hh

#include <vector>
#include "PackageHe3.hh"


namespace Parser {
  class EXPORT_SYMBOL PackageHe3PosCorr: public PackageHe3 {
  public:
    PackageHe3PosCorr(double threshold_lower, double threshold_upper, double hvlength=150., double tofscale=1./80);
    ~PackageHe3PosCorr() override;
    //fixme: hit position is scale by a constant 150
    //returns false when reach the end of the data stream
    bool extractNextPackage(const uint8_t*& pt, const uint8_t * const stream_end, std::vector<HitInfo>& hitinfo) const override;
  private:
    double m_charge_threshold_upper;
    std::vector<double> m_kfactor, m_bfactor;


  };
}
#endif
