#include "PackageMWPC_v2.hh"
#include <iostream>       // std::cout
#include <bitset>
#include <algorithm>
#include <cmath>

#include "UtilsException.hh"
#include "Hist2DMap.hh"
#include "NumpyHist1D.hh"

Parser::PackageMWPC_v2::PackageMWPC_v2(double threshold, double time_window)
:ParserMWPC(), m_charge_threshold(threshold), m_time_window(time_window), m_last_t0(0)
{
}

Parser::PackageMWPC_v2::~PackageMWPC_v2()
{
}
unsigned eventcnt = 0;



bool Parser::PackageMWPC_v2::extractNextPackage(const uint8_t*& pt, const uint8_t * const stream_end, std::vector<HitInfo>& hitinfo) const
{
  //a new package eventDataArrived
  //we first check if this package and the data in buffer are from the same T0 peroid
  //if yes, accumulate package data into the buffer
  //otherwise, process the old buffer and clean it for this package

  const uint8_t *package_end;
  uint64_t offset=0;
  if(!findNextPackageStartEnd(stream_end, pt, package_end, offset))
    return false;

  //parsing raw data
  ParserMWPC::MWPCHeader header;
  readHeader(pt, header);
  unsigned mapnum = header.map_num;
  //x chanel 50, spacing 4mm, y channel 94, spacing 2.2mm
  // std::bitset<50> x; //In standard C++, bits are initialized with zeros
  // std::bitset<94> y;

  if(!m_last_t0)
    m_last_t0 = header.t0cnt;

  //if this is the start of a new t0 signal
  //process whatever in the map and get ready to restart the accumulation
  if(header.t0cnt!=m_last_t0 && !m_hit.empty())
  {
    //the arrived new package belongs to a subconsequente T0 event, so the old
    // data in the buffer should be sorted and analysed
    std::sort(m_hit.begin(), m_hit.end());

    uint8_t chnl = 0;
    uint16_t Q = 0;
    unsigned chargeSum = 0;
    uint32_t eventSz(0), accu_x(0), accu_y(0), accu_xw(0), accu_yw(0);
    uint64_t hittof=m_hit.front(); //initialize for the loop

    uint64_t realtwindow = m_time_window<<32;


    for(auto ahit: m_hit)
    {
      getChannelCharge( ahit, chnl, Q);
      if(Q<m_charge_threshold)
        continue;

      if(ahit > hittof + realtwindow ) // || it==last_item_in_map??
      {
        //this hit belongs to the next event
        eventcnt++;

        //fill histograms only if both x and y data are available
        if(accu_x*accu_y)
        {
          float x = accu_xw/float(accu_x);
          float y = accu_yw/float(accu_y);
          hitinfo.push_back(HitInfo(   y*2.2, (50-x)*4. ,
          hittof/40. , chargeSum , header.t0cnt, 0));
          //printf("%g;%g;%g;%d;  %d\n", y*2.2, (50-x)*4., hittof/40.0, header.t0cnt-1, eventcnt-1 );
        }
      }
      else
      {
        //accumulate
        // printf("%d %d %d %d\n",eventcnt, it->first, chnl, Q);
        eventSz++;
        chnl<51 ? accu_xw += chnl*Q : accu_yw += (chnl-50)*Q;
        chnl<51 ? accu_x += Q : accu_y += Q;
        chargeSum += Q;
      }

    }

    std::vector<uint64_t>  temp; //release memory
    m_hit.swap(temp);
    m_last_t0=header.t0cnt;
  }

  //Sorting hit data
  // printf("*********%d maps************\n",header.map_num);

  printf("left %ld, package_end %p, stream_end %p\n", stream_end-package_end, package_end, stream_end);
  pushbackRawData(header.map_num, package_end);
  return package_end==stream_end?false:true;

}

void Parser::PackageMWPC_v2::pushbackRawData(unsigned eventmapnum, const uint8_t *&pt) const
{
  uint32_t temp32=0;

  for(unsigned imap=0;imap<eventmapnum;imap++)
  {
    error_assert(*pt == 0xAA);
    uint32_t t = 0;
    read_uint32(pt,t);
    t &= MASK_24;
    // printf("TdataID %d\n", t);
    uint32_t eventNum = 0;
    read_uint32(pt,eventNum);

    // printf("map %d, event number %d \n",imap, eventNum);
    for(unsigned ievt=0;ievt<eventNum;ievt++)
    {
      uint8_t ch = *(pt);

      read_uint32(pt, temp32);
      //error_assert(ch==*(pt));
      uint32_t t_hi_res = temp32&MASK_24;

      read_uint32(pt, temp32);
      //fixme: there is a bug in DAQ, the secend channel num sometimes are left zero
      temp32 = (temp32&MASK_24) + (ch<<24);

      m_hit.push_back(( ((uint64_t) t_hi_res) <<32) + temp32);
      //printf("ch %d, time stamp %d\n", temp32, t_hi_res);
    }
  }


}

void Parser::PackageMWPC_v2::write(std::ofstream &file, const char *filename)
{
  file.open(filename);
  auto it=m_tof_cq_map.begin();
  for(;it!=m_tof_cq_map.end();++it)
  {
    uint32_t temp32 = it->second;
    file << it->first << " " << ( temp32>>24) << " "  <<( (temp32&MASK_12) - ( (temp32>>12)&MASK_12) )<< "\n";
  }
  file.close();
}

void Parser::PackageMWPC_v2::print() const
{
  uint8_t ch = 0;
  uint16_t Q = 0;
  for(auto it: m_tof_cq_map)
  {
    getChannelCharge(it.second, ch, Q);
    std::cout << it.first << " " << (uint16_t)ch << " " << Q << std::endl;
  }
  std::cout << std::endl;
}
