#ifndef Parser_ParserBase_hh
#define Parser_ParserBase_hh

#include <stdint.h>
#include <vector>
#include <string>
#include "ctypes_api.hh"

//This is the base class for decoding detector raw data.
//fixme change to stream based class
namespace EXPORT_SYMBOL Parser {

  struct HitInfo {
    double pos;
    double posy;
    double t;
    double chargesum;
    uint32_t hit_t0;
    uint8_t id;
    HitInfo(): pos(0.),posy(0.), t(0.),chargesum(0.),hit_t0(0), id(0) {}
    HitInfo(double position, double positiony, double time, double chargesum,uint32_t t0, uint8_t tube)
      : pos(position),posy(positiony), t(time),chargesum(chargesum), hit_t0(t0), id(tube) {}
  };


  class ParserBase {
  public:
    ParserBase();
    virtual ~ParserBase();

    //read unsigned 32-bit integer from buffer
    void read_uint32(const uint8_t*& pt, uint32_t &u32) const;
    //slow, use with care
    inline void read_uint32_many(const uint8_t*& pt, std::vector<uint32_t> &u32_vec, unsigned num=4) const;


    //check if data is blank ( more than 112 zeros)
    bool blankData(const uint8_t* const pt, const uint8_t * const stream_end) const;


    //find the end position of a package
    //Function returns true if the end position of a valid package is found
    virtual bool findEnd(const uint8_t* const pt, const uint8_t* const end, const uint8_t*& pkgend) const = 0 ;

    //sanity check. Slow, use with care. fixme: validation should be more detailed
    virtual bool is_valid(const uint8_t* pt) const = 0 ;

    //extract info from next package
    virtual bool extractNextPackage(const uint8_t*& pt, const uint8_t * const stream_end, std::vector<HitInfo>& hitinfo) const = 0;

    //search for next valid package. Slow, use with care.
    virtual bool findNextPackageStartEnd(const uint8_t * const stream_end, const uint8_t*& okgstart,  const uint8_t*& pkgend, uint64_t &offset) const ;

  public:
    enum BIT_MASK: uint32_t {
      MASK_4  = 0XF,
      MASK_6  = 0X3F,
      MASK_8  = 0XFF,
      MASK_12  = 0XFFF,
      MASK_14  = 0X3FFF,
      MASK_16 = 0XFFFF,
      MASK_20 = 0xFFFFF,
      MASK_24 = 0XFFFFFF,
      MASK_28 = 0XFFFFFFF
    };

  };

  inline void Parser::ParserBase::read_uint32(const uint8_t*& pt, uint32_t &u32) const
  {
    //endian free
    //Fixme: could be optimised after profiling
    u32 = (*pt)<<24 ;
    u32 += (*(++pt))<<16 ;
    u32 += (*(++pt))<<8 ;
    u32 += *(++pt) ;
    pt++;
  }

}
#endif
