#ifndef Parser_PackageMWPC_v2_hh
#define Parser_PackageMWPC_v2_hh

#include <map>
#include "ParserMWPC.hh"
#include <fstream>

class Hist2DMap;

class NumpyHist1D;

//This class reads information from a full package.
namespace Parser {
  //fixme :  put m_detector_half_length and m_tof2us elsewhere
  class EXPORT_SYMBOL PackageMWPC_v2: public ParserMWPC {
  public:
    PackageMWPC_v2(double threshold, double time_window );
    ~PackageMWPC_v2() override;

    //returns false when reach the end of the data stream
    bool readNextPackage(const uint8_t*& pt, const uint8_t * const stream_end,
                         Hist2DMap &hitmap,
                         NumpyHist1D &qhist) const;

    bool extractNextPackage(const uint8_t*& pt, const uint8_t * const stream_end, std::vector<HitInfo>& hitinfo) const override;

    void write(std::ofstream &file, const char *filename);
    void print() const;

    double getChargeThreshold() const;
    void setChargeThreshold(double charge);

  private:
    double m_charge_threshold;
    uint64_t m_time_window;
    mutable uint32_t m_last_t0;
    mutable std::multimap<uint32_t,uint32_t> m_tof_cq_map; //<TOF, chanel+Q>
    mutable std::vector<uint64_t> m_hit;

    void pushbackRawData(unsigned eventmapnum, const uint8_t *&pt) const;

    inline void getChannelCharge(uint32_t in, uint8_t& channel, uint16_t& charge ) const;

  };

  inline void Parser::PackageMWPC_v2::getChannelCharge(uint32_t in, uint8_t& channel, uint16_t& charge) const
  {
    channel = in>>24;
    uint16_t baseline = ((in>>12)&MASK_12) ; //fixme the document states the baseline value is the combination of 8 samples!?
    uint16_t chage = (in&MASK_12) ;
    charge = chage>baseline ? chage-baseline: 0  ; //fixme emit warning if overflowed
  }
}
#endif
