#include <dic.hxx>
#include <iostream>
#include <vector>
#include <string>
#include <fstream>
#include <memory>
#include <chrono>
#include <future>
#include <nlohmann/json.hpp>

#include "DAQInterface.hh"
#include "Hist2DMap.hh"
#include "RedisIO.hh"
#include "Earthworm.hh"
#include "RedisNumpy.hh"
#include "MyStateMachine.hh"

#include "Action_MR.hh"

int main()
{
	std::cout << "Starting client..." << std::endl;


	//redis should retrive all parameters

	std::shared_ptr<RedisIO> redis(new RedisIO(9001, "neonmaster", "sanlie;123"));
	unsigned pid_num(300), tof_num(2500);
  std::shared_ptr<Hist2DMap> histmap(new Hist2DMap(tof_num, 0 , 40000, pid_num, 0, 300 , Hist2DMap::DetectorType::kHe3) );
	std::shared_ptr<MyStateMachine> sMachine (new MyStateMachine());

  Action_MR action(redis, histmap, sMachine);

	sMachine->grantStateTransit(State::kUnconfigured, State::kReady, Command::kConfigure, std::bind( &Action_MR::configure, action), "configure");
  sMachine->grantStateTransit(State::kReady, State::kUnconfigured, Command::kUnconfigure, std::bind( &Action_MR::unconfigure, action), "unconfigure");
  sMachine->grantStateTransit(State::kReady, State::kRunning, Command::kStart, std::bind( &Action_MR::start, action), "start");
  sMachine->grantStateTransit(State::kRunning, State::kReady, Command::kStop, std::bind( &Action_MR::pauseStop, action), "pauseStop");
  sMachine->grantStateTransit(State::kRunning, State::kPaused, Command::kPause, std::bind( &Action_MR::pauseStop, action), "pauseStop");
  sMachine->grantStateTransit(State::kPaused, State::kRunning, Command::kResume, std::bind( &Action_MR::resume, action), "resume");
  sMachine->grantStateTransit(State::kRunning, State::kUnconfigured, Command::kAbort, std::bind( &Action_MR::unconfigure, action), "unconfigure");
  sMachine->grantStateTransit(State::kPaused, State::kUnconfigured, Command::kAbort, std::bind( &Action_MR::unconfigure, action), "unconfigure");
	sMachine->grantStateTransit(State::kRunning, State::kRunning, Command::kStart, std::bind( &Action_MR::keepRunning, action), "keepRunning");
	sMachine->grantGlobalTransitTo(State::kError, Command::kKill, std::bind( &Action_MR::kill, action), "kill");


  //selfDiagnosis() generates 10k state and command in random combination,
  //and record those in fact can change the state
  sMachine->selfDiagnosis();
	//sMachine->sendHeartBeat();

	// while(action.breakLoop())
	// {
	// 	std::this_thread::sleep_for(std::chrono::milliseconds(100));
  // }


	EW_LOG_INFO("Earthworm_mr is exiting...");
  return 0;
}
