#ifndef TrajAna_hh
#define TrajAna_hh
#include <stdexcept>
#include <vector>

#include "ctypes_api.hh"

#include "ctypes_api.hh"

#ifdef __cplusplus
extern "C" {
#endif

void test(double* vec, unsigned vecsize)
{
  for(unsigned i=0;i<vecsize;i++)
  {
    printf("i %d, %g\n", i, vec[i]);
  }
}

class NumpyHist1D;

EXPORT_SYMBOL void cvv(double* vel, unsigned velSize,
         unsigned *atomicPair, unsigned atomicPairSize,
         double* returnPointer, unsigned retsize,
         unsigned nAtom, unsigned nTimeStep);

double cvv_t(const std::vector<double*>& vel1, const std::vector<double*>& vel2,
 unsigned timeIdx, unsigned nTimeStep);

EXPORT_SYMBOL double fsqt(double* atomPos1, unsigned atomPos1Size,
  double* atomPos2, unsigned atomPos2Size,
  double *box, unsigned boxSize, double q,
  unsigned timeIdx, unsigned nAtom, unsigned nStep);

EXPORT_SYMBOL double vaf(double* vel, unsigned velSize,
  unsigned idx, unsigned nAtom, unsigned nStep);

EXPORT_SYMBOL void vaf_vec(double* vel, unsigned velSize,
             double* returnPointer, unsigned retsize,
             unsigned nAtom, unsigned nStep);

//returnPointer is G(t,r) *4*pi*r*r in numpy array
EXPORT_SYMBOL void gtr_vec(double* traj, unsigned trajSize,
            unsigned *atomicPair, unsigned atomicPairSize,
            double *box, unsigned boxSize,
            double* returnPointer, unsigned retsize,
            unsigned numWavlengtBin, double wavelengthCut,
            double dltT, unsigned nAtom, unsigned nTimeStep);


//Fill the histogram with the space time correlation of two atoms with a fixed lagTime
//in the reference of first atom position
EXPORT_SYMBOL void pairCorrelation(NumpyHist1D& hist,
             const std::vector<double*>& atomPos1, const std::vector<double*>& atomPos2,
              double *box, unsigned boxSize,
              unsigned nTimeStep, unsigned timeIdx);

EXPORT_SYMBOL void intermediate(double* traj, unsigned trajSize,
    unsigned *atomicPair, unsigned atomicPairSize,
    double *box, unsigned boxSize,
    double *q, unsigned qSize,
    unsigned *timeStep, unsigned TimStepSize,
    unsigned nAtom, unsigned nTimeStep, double* FsTQ, unsigned FsTQSize);


void normalisePairCorrelationHist(NumpyHist1D& hist, double rSpacing, std::vector<double>& normalisedDist);

void qtCorrelation(const std::vector<double*>& atomPos1, const std::vector<double*>& atomPos2, unsigned nTimeStep, unsigned timeIdx,
  double *box, unsigned boxSize, double *q, unsigned qSize, std::vector<double>& fq);

void qtCorrelation1d(const std::vector<double*>& atomPos1, const std::vector<double*>& atomPos2, unsigned nTimeStep, unsigned timeIdx,
    double *box, unsigned boxSize, double *q, unsigned qSize, std::vector<double>& fq);

void qtCorrelationHist(const std::vector<double*>& atomPos1, const std::vector<double*>& atomPos2, unsigned nTimeStep, unsigned timeIdx,
    double *box, unsigned boxSize, double *q, unsigned qSize, std::vector<double>& fq);

double ncabs(double a);
class StableSum {
public:
  //Numerically stable summation, based on Neumaier's
  //algorithm (doi:10.1002/zamm.19740540106).
  StableSum();
  ~StableSum();
  void add(double x);
  double sum() const;
private:
  double m_sum, m_correction;
};


#include "TrajAna.icc"

#ifdef __cplusplus
}
#endif

#endif
