#include "NumpyHist1D.hh"
#include <cmath>
#include <vector>

NumpyHist1D::NumpyHist1D(unsigned nbins, double xmin, double xmax)
:NumpyHistBase(), m_binfactor(nbins/(xmax-xmin))
{
  m_xmin=xmin, m_xmax=xmax, m_nbins=nbins;
  m_data = new double[nbins];
}

NumpyHist1D::~NumpyHist1D()
{
  delete []m_data;
}


void NumpyHist1D::serialise(std::string &serialised) const
{
  serialise_numpy(std::vector<uint64_t>{m_nbins}, serialised);
}

//Normal filling:
void NumpyHist1D::fill(double val)
{
  if(val<m_xmin) {
    m_underflow++;
    return;
  }
  else if(val>m_xmax) {
    m_overflow++;
    return;
  }

  unsigned i = floor((val-m_xmin)*m_binfactor);
  ++m_data[i];
}

void NumpyHist1D::fill(double val, double w)
{
  if(val<m_xmin) {
    m_underflow += w;
    return;
  }
  else if(val>m_xmax) {
    m_overflow += w;
    return;
  }

  unsigned i = floor((val-m_xmin)*m_binfactor);
  m_data[i] += w;
}
