#ifndef NumpyHistBase_hh
#define NumpyHistBase_hh

#include <string>
#include <cassert>
#include <vector>

class NumpyHistBase {
public:
  NumpyHistBase();
  virtual ~NumpyHistBase();

  double getXMin() const {return m_xmin;}
  double getXMax() const {return m_xmax;}
  double getIntegral() const {return m_sumW;};
  double getOverflow() const {return m_overflow;};
  double getUnderflow() const {return m_underflow;};
  double getMinFilled() const {return m_minfilled;};
  double getMaxFilled() const {return m_maxfilled;};
  double getNBins() const {return m_nbins;};

  void scale(double scalefact);
  void reset();
  void save(const std::string &filename) const;

  virtual unsigned dimension() const = 0;
  virtual void serialise(std::string &serialised) const = 0;
  //Reset to unfilled state:

protected:
  void serialise_numpy(const std::vector<uint64_t> &shape, std::string &serialised) const;

  double *m_data;
  double m_xmin;
  double m_xmax;
  double m_sumW;
  double m_underflow;
  double m_overflow;
  double m_minfilled;
  double m_maxfilled;
  uint32_t m_nbins;

private:
  //Copy/assignment is forbidden:
  NumpyHistBase( const NumpyHistBase & );
  NumpyHistBase & operator= ( const NumpyHistBase & );

};

#endif
