#include <cstdio>
#include <fstream>
#include <vector>
#include <string>
#include <iostream>
#include <fstream>


#include "ParserUtils.hh"
#include "PackageHe3.hh"
#include "NumpyHist1D.hh"

int main(int argc, char *argv[])
{
  //read data
  //std::string fname = "/home/dur/BL02/DAQ/RUN0007423/BL02_RUN0007423_He3MODULE_FILE001_20191228134110.dat";
  std::string fname = "/home/caixx/ownCloud/Work/DIM/data/BL02_RUN0005344_He3MODULE_FILE001_20190625110252.dat";
  std::ifstream source(fname, std::ifstream::ate|std::ios_base::binary);
  // get length of file:
  source.seekg (0, source.end);
  int length = source.tellg();
  source.seekg (0, source.beg);

  //std::cout<<"223:"<<length<<std::endl;
  // allocate memory:
  const uint8_t * buffer = new uint8_t [length];

  // read data as a block:
  source.read (reinterpret_cast<char*>(const_cast<uint8_t *>(buffer)),length);
  source.close();

  printf("file size is %d \n", length);
  std::cout<<333<<std::endl;

  auto *he3 = new Parser::PackageHe3(0.);
  std::vector<Parser::HitInfo> hitinfo;
  unsigned loop=0, event_cnt = 0;

  auto hist_tube = new NumpyHist1D(12,-.5,11.5);
  auto hist_charge = new NumpyHist1D(1000,-.5,30000.5);
  auto hist_pos = new NumpyHist1D(1000,0,300.);
  auto hist_tof = new NumpyHist1D(1000,0,40000.);


  for(unsigned i=0;i<1;i++){
    const uint8_t * abuf = buffer;
    while(he3->readNextPackage(abuf, buffer+length, hitinfo))
    {
      loop++;
      event_cnt+=hitinfo.size();
      for(auto v: hitinfo)
      {
        hist_tube->fill(v.tube_id);
        if(v.tube_id==7 )
        {
          hist_charge->fill(v.chargesum);
          hist_pos->fill(v.pos);
          hist_tof->fill(v.t);
        }
        printf("%g %d %g\n", v.pos, v.tube_id, v.t);
      }
    }
  }
  // hist_tube->dump(true,"tube_id ");
  //
  // hist_charge->dump();
  // unsigned binnum = hist_charge->getNBins();
  // std::ofstream fhist;
  // fhist.open ("hist_charge.txt");
  // for(unsigned i=0;i<binnum;i++)
  // {
  //   fhist << hist_charge->getBinCenter(i) << " "
  //   << hist_charge->getBinContent(i)<< "\n";
  // }
  // fhist.close();
  //
  // fhist.open ("hist_pos.txt");
  // binnum = hist_pos->getNBins();
  // for(unsigned i=0;i<binnum;i++)
  // {
  //   fhist << hist_pos->getBinCenter(i) << " "
  //   << hist_pos->getBinContent(i)<< "\n";
  // }
  // fhist.close();
  //
  // fhist.open ("hist_tof.txt");
  // binnum = hist_tof->getNBins();
  // for(unsigned i=0;i<binnum;i++)
  // {
  //   fhist << hist_tof->getBinCenter(i) << " "
  //   << hist_tof->getBinContent(i)<< "\n";
  // }
  // fhist.close();
  //
  //
  // delete hist_tube,hist_charge;
  // printf("read %d valid packages, %d events in total\n",loop, event_cnt);
  // delete []buffer;



  return 0;

}
