#!/usr/bin/python

from __future__ import print_function
import vacf
import time
import sys
import h5py
import numpy as np
#from multiprocessing import Pool
import matplotlib.pyplot as plt

folder = ''
if len(sys.argv)==2:
    folder = sys.argv[1]+'/'

f=h5py.File(folder+'dump_h5md.h5','r')

#For style real, these are the units:
#mass = grams/mole
#distance = Angstroms
#time = femtoseconds
#energy = Kcal/mole
#velocity = Angstroms/femtosecond
#force = Kcal/mole-Angstrom
#torque = Kcal/mole
#temperature = Kelvin
#pressure = atmospheres
#dynamic viscosity = Poise
#charge = multiple of electron charge (1.0 is a proton)
#dipole = charge*Angstroms
#electric field = volts/Angstrom
#density = gram/cm^dim

#[step, atom, value]
species=f['particles']['all']['species']['value'][()]
box=f['particles']['all']['box']['edges']['value'][()]

def trim(data, spe, key):
  old_shape = data.shape
  data=data[spe==key,:]
  atomLeft = data.shape[0]/old_shape[0]
  #1. get the corret shape
  #2. swap axes to [atomID, stepID, data]
  #3. make data contiguous
  return np.ascontiguousarray(np.swapaxes(data.reshape([old_shape[0], atomLeft, 3]),0,1))

def getDeltaT(time):
  return (time[1]-time[0])*1e-15  #in fetosecond

pos = trim(f['particles']['all']['position']['value'][()],species,1)
vel= trim(f['particles']['all']['velocity']['value'][()] ,species,1)


deltaT = getDeltaT(f['particles']['all']['species']['time'][()])

f.close()

nStep= pos.shape[1]
nAtom = pos.shape[0]
sampleRate = 1/deltaT #per second

#1 rad/sec = 6.5821e-16 eV
radpsec2meV =  6.5821e-13 * 2*np.pi

print ('Delta time ',deltaT*1e15,'fs')
print ('Velocity size after trim ', pos.shape)


def spaceTime(idx): #idx must <= nStep
    tot =0.
    for n in range(nAtom):
        tot += (pos[0:(nStep-idx),n]-pos[idx:nStep,n]).sum(axis=0)
    return tot/(nAtom*(nStep-idx))

# # #########python
# def vaff(idx): #idx must <= nStep
#     tot =0.
#     for n in range(nAtom):
#         tot += (vel[n,0:(nStep-idx)]*vel[n,idx:nStep]).sum()
#     return tot/(nAtom*(nStep-idx))
#
# pool = Pool(8)
# stepIdx=np.arange(int(nStep/2))
# start_time = time.time()
# resultVaf = pool.map(vaff, stepIdx)
# print  ('pure python elapsed ' , time.time() - start_time, 's')
# dos=np.fft.fft(resultVaf)
# enmeV = np.fft.fftfreq(len(dos)) * sampleRate *radpsec2meV
# plt.plot(enmeV, dos.real, 'o', label='python')

#####c
vac_arr = np.zeros(nStep/2)

start_time = time.time()
vacf.vacf_vec(vel, vel.size, vac_arr, vac_arr.size, nAtom,  nStep)
print  ('c function elapsed ' , time.time() - start_time, 's')

dos=np.fft.fft(vac_arr)
enmeV = np.fft.fftfreq(len(dos)) * sampleRate *radpsec2meV
plt.plot(enmeV, dos.real, label='c')
plt.xlim([0, sampleRate *radpsec2meV/2])
plt.legend(loc=0)
plt.show()
