#include "Earthworm.hh"

#include <sys/types.h>
#include <dirent.h>
#include <cstddef>
#include <string>
#include <vector>
#include <iostream>

#include <tinyxml.h>
#include <fstream>
#include "NeXusFile.hpp"
#include <map>
#include "parserXML.h"
#include "parserNXS.h"
#include <math.h>
#include <memory.h>
#include <stdio.h>
#include <typeinfo>
#include <dirent.h>
#include <unistd.h>

using namespace std;

int dim[1]={0};

int main(int argc, char *argv[])
//int main()
{
   
    if(argc<=1)
    {
        printf("Usage:%s runNumber prepath\n", argv[0]);
        return 0;
    }
    

    string beamline = argv[1];
    //string beamline = "BL18"; //This is for gdb test
    string runNo=argv[2];
    //string runNo="RUN0006706"; //This is for gdb test
    //get conf file
    //string confFile = "configure.xml";
    string confFile="/home/mantid/git/Earthworm/build/gen_nexus/configure.xml"

    ParserNXS m_nxs(beamline, runNo, confFile);
    m_nxs.getConfInfo();
    m_nxs.createNXS();
    m_nxs.setPublic();
    m_nxs.setLogs();
    m_nxs.setInstrument();
    m_nxs.setEventData();
    m_nxs.setHistData();
    
    cout<<"finish save nexus"<<endl;
    string path = "./"+runNo+"/complete.dat";
    //string path = "/home/mantid/workspace/recNexus/"+runNo+"/complete.dat";
    std::ofstream markfile;
    markfile.open(path.c_str());
    markfile<<"completed"<<endl;
    markfile.close();
	
    return 0;
}

