#ifndef IncPARSEXML
#define IncPARSEXML

#include <string>
#include <map>
#include <vector>
#include <list>
#include <tinyxml.h>
using namespace std;

struct CSNSgeometry{
        float ori[6];
        string shape;
        float size[3];
        float distances[3];
};

struct CSNSse{
        string seName;
        string name;
        string type;
        float pressure;
        float temperature;
        float t2;
        float magnetic_field;
        float electric_field;
};

struct CSNSsample{
        string chemical_formula;
        string name;
        string type;
        string situation;
        float distance;
        float density;
        float mass;
        CSNSgeometry geometry;
};

struct CSNSsource{
        string name;
        string type;
        string probe;
        float frequency;
        float power;
};

struct CSNSmoderator{
        string type;
        float distance;
        float temperature;
};

struct CSNSbs{
        CSNSgeometry geometry;
        float distance[3];
        string status;
};

struct CSNSaperture{
        string apertureName;
        float xgap;
        float ygap;
};
struct CSNSslit{
        string slitName;
        float xgap;
        float ygap;
};

struct CSNSdc{
        string dcName;
        float phase;
        float slitAngle;
        float distance;
        float rotationSpeed;
};

struct CSNSlogs{
        string name;
        vector<string> filePath;
};

struct CSNSdet{
        string name;
        string local_name;
        string mode;
        float delay;
        float rotate_angle;
        float distance;
};

struct CSNSfp{
    string name;
    string type;
    float pc;
    int spin;
};

struct CSNSpz{
    string name;
    string type;
    
};

struct CSNSaz{
    string name;
    string usage;
};

class ParseXML {
    public:

        ParseXML(string filename)
        {
            cout<<"start load "<<filename<<endl;
            TiXmlDocument *doc=new TiXmlDocument(filename.c_str());
            doc->LoadFile();
            if (doc==NULL)
                cout<<"error: no such xml file!"<<endl;
            else
                root=doc->RootElement();       
                cout<<"doc for parse xml: "<<doc<<" root: "<<root->Value()<<endl;
        }

       // ~ParseXML();
        //Config(string configFile, char** envp = 0);
        //~Config();
       map<string, float> getTofInfo();
       //float getTofDelay(string name, bool bm);
        map<string, string> getPublic();
        CSNSsample getSample();
        CSNSsource getSource();
        CSNSmoderator getModerator();
        vector<CSNSse> getSE();
        CSNSbs getBS();
        vector<CSNSaperture> getAperture();
        vector<CSNSslit> getSlit();
        vector<CSNSdc> getDC();
        vector<CSNSfp> getFP();
        vector<CSNSpz> getPZ();
        vector<CSNSaz> getAZ();
        vector<CSNSlogs> getLogs();
        vector<string> getBankName();
        CSNSdet getDetector();
        CSNSdet getMonitor();
        map<string, float> getModuleInfo(const char* moduleName);
        void getMonitorPos(float (*pos)[3], const char* monitorName);
        map<string, float> getMonitorInfo(const char* idName);
        void setBankInfo(const char* bankName, float distance[], int64_t* pid, float* r, float* theta, float* phi);
    private:
        TiXmlElement *root;
        TiXmlElement *group, *search, *psearch;
        TiXmlText *text;
        TiXmlAttribute *attr;

        std::vector<std::string> split(string str, string sep);
        // private constructor for sub groups
        //Config(string name, string parentDebugInfo);
        //get node point by special name and attr 
        string getStringValue(string name, TiXmlElement *node);
        float getNumValue(string name, TiXmlElement *node);
        vector<float> getArrayValue(string name, TiXmlElement *node, int num); 
        bool getNode(TiXmlElement *tree,TiXmlElement * &destNode, const char* nodeName);
        bool getNode(TiXmlElement *tree,TiXmlElement * &destNode,const char* nodeName, const char* attrName, const char* attrValue);
        //int getNodeNum(TiXmlElement *root, const char* nodeName, TiXmlElement * &destNode);
        CSNSgeometry getGeometry(TiXmlElement *node);
        void getDistance(TiXmlElement *node, float distance[]);

};

#endif
