#include "parseXML.h"
#include "parseNXS.h"
#include <typeinfo>
#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <fstream>
#include "NeXusFile.hpp"
#include <vector>
#include <dirent.h>
#include <unistd.h>
#include <nlohmann/json.hpp>
#include "ParserUtils.hh"
#include "PackageHe3.hh"
#include "NumpyHist1D.hh"

using json = nlohmann::json;

using namespace std;


vector<string> ParseNXS::split(string str, string sep)
{
   char* cstr=const_cast<char*>(str.c_str());
    char* current;
    std::vector<std::string> arr;
    current=strtok(cstr,sep.c_str());
    while(current!=NULL){
        arr.push_back(current);
        current=strtok(NULL,sep.c_str());
    }
    return arr;
}


void ParseNXS::getEventData(string daqFilename, uint64_t& evtNum, std::vector<int64_t> &pid, std::vector<float> &tof, std::vector<uint64_t> &pulse)
{
    std::ifstream source(daqFilename, std::ifstream::ate|std::ios_base::binary);
    source.seekg (0, source.end);
    int length = source.tellg();
    source.seekg (0, source.beg);
    const uint8_t * buffer = new uint8_t [length];
    //cout<<456<<endl;
    source.read (reinterpret_cast<char*>(const_cast<uint8_t *>(buffer)),length);
    source.close();

    auto *he3 = new Parser::PackageHe3(0.);
    std::vector<Parser::HitInfo> hitinfo;
    unsigned loop=0, event_cnt = 0;

    const uint8_t * abuf = buffer;
     std::map<uint32_t, uint32_t> mapfile;
        mapfile.insert(make_pair(7,1));
        mapfile.insert(make_pair(8,2));
        mapfile.insert(make_pair(9,3));
        mapfile.insert(make_pair(11,4));
        uint32_t tmp=0;
        uint32_t m_bins = 300;
    uint32_t n = 0;
    while(he3->readNextPackage(abuf, buffer+length, hitinfo))
    {
      event_cnt+=hitinfo.size();
      for(auto v: hitinfo)
      {
        tmp = mapfile[v.tube_id]; 
        pid.push_back(100001+m_bins*(tmp-1)+int(v.pos));
        tof.push_back(v.t);
        pulse.push_back(v.hit_t0);
        n++;
      }
    }
    evtNum = n-1;
    cout<<"evt num: "<<evtNum<<endl;
}


void ParseNXS::getEvtDataFromDrone(string prepath,string moduleName, uint64_t& evtNum, std::vector<int64_t> &pid, std::vector<float> &tof, std::vector<uint64_t> &pulse)
{
    string path = prepath+"/evt_"+moduleName+".dat";
    cout<<"evt data path "<<path<<endl;
    std::ifstream evtfile(path.c_str());
    string evtbuff;
    if(evtfile.is_open()){
        while(getline(evtfile, evtbuff)){
            vector<string> substring;
            substring = split(evtbuff, ";");
            pid.push_back(atoi(substring[0].c_str()));
            tof.push_back(atof(substring[1].c_str()));
            pulse.push_back(atoi(substring[2].c_str()));
        }
    evtfile.close();
    evtNum = pid.size();
    }else{
        cout<<"can't open daq file!"<<endl;
        string path = prepath+"/noDAQ";
        std::ofstream markfile;
        markfile.open(path.c_str());
        markfile.close();
    }
}


void ParseNXS::getMonitorData(string filename, const int pids, const int tBins, std::vector<uint32_t> &histData)
{
    std::ifstream histfile(filename.c_str(), ios::binary);
    uint32_t** buffer = new uint32_t* [pids];
    if(histfile.is_open())
    {
        histfile.seekg(0, histfile.end);
        histfile.seekg(0, histfile.beg);
        for(int i = 0; i< pids; i++){
            buffer[i] = new uint32_t [timeBin];
            histfile.read((char*)buffer[i],tBins*sizeof(uint32_t));
        }
        histfile.close();
        int a=0;
        uint64_t n = 0;
        for(int i=0; i<pids; i++){
            for(int j=0; j<tBins; j++){
                a+=buffer[i][j];
                histData.push_back(buffer[i][j]);
                n++;
            }
        }
        cout<<"total neutron counts: "<<a<<endl;
    }
}

void ParseNXS::getHistDataFromDrone(string prepath,string moduleName, std::vector<uint32_t> &histData)
{
    string path = prepath+"/hist_"+moduleName+".dat";
    cout<<"hist data path "<<path<<endl;
    std::ifstream histfile(path.c_str());
    string histbuff;
    uint64_t b = 0;
    uint64_t n = 0;
    vector<string> substring;
    if(histfile.is_open()){
        while(getline(histfile, histbuff)){
            substring = split(histbuff, ";");
            for (int i = 0; i<substring.size(); i++){
                histData.push_back(atoi(substring[i].c_str()));
                n++;
            }
            b++;
        }
        cout<<substring.size()<<";"<<n<<endl;
        histfile.close();
    }else{
        cout<<"can't open daq file!"<<endl;
        string path = prepath+"/noDAQ";
        std::ofstream markfile;
        markfile.open(path.c_str());
        markfile.close();
    }
}


/*
   void ParseNXS::getMonitorData(string monFile, const int pixels, std::vector<uint32_t> &histData)
   {
//name[0]=toupper(name[0]);

DIR *dirp;
struct dirent *dp;
//string filepath="/opt/CSNSDATA/TS1/BL18/Monitor/Histogram/"+name+"/"+runno;
dirp=opendir(monFilepath.c_str());
while((dp = readdir(dirp))!=NULL)
{if(strlen(dp->d_name)<=3) continue;
string target;
target=monFile+"/"+dp->d_name;
//name[0]=tolower(name[0]);
cout<<target<<endl;
std::ifstream histfile(target.c_str(), ios::binary);
const int timeBin = 40000;
uint32_t** buffer = new uint32_t* [pixels];
if(histfile.is_open())
{
histfile.seekg(0, histfile.end);
histfile.seekg(0, histfile.beg);
for(int i = 0; i< pixels; i++){
buffer[i] = new uint32_t [timeBin];
histfile.read((char*)buffer[i],timeBin*sizeof(uint32_t));
}
histfile.close();
int a=0;
for(int i=0; i<pixels; i++){
for(int j=0; j<timeBin; j++){
a+=buffer[i][j];
histData.push_back(buffer[i][j]);
}
}
cout<<"total neutron counts: "<<a<<endl;
}else{
cout<<"can't open file!"<<endl;
//string path = prepath+"/"+runno+"/no"+name;
//std::ofstream markfile;
//markfile.open(path.c_str());
//markfile.close();
}
}
*/
void ParseNXS::writeGroup(NXstatus status, NXhandle fileID, const char* groupName, const char* groupType)
{
    status=NXmakegroup(fileID,groupName,groupType);
    status=NXopengroup(fileID,groupName,groupType);
}
void ParseNXS::writeCharData(NXstatus status, NXhandle fileID, const std::string dataName, const std::string dataValue)
{
    int dim[1] = {dataValue.size()};
    char* p = (char*)dataName.data();
    status=NXmakedata(fileID,p,NeXus::CHAR,1,dim);
    status=NXopendata(fileID,p);
    status=NXputdata(fileID,dataValue.c_str());
    status=NXclosedata(fileID);
}
//write slab data
void ParseNXS::writeSlabData(NXstatus status, NXhandle fileID, const std::string dataName, const float* dataValue, int dim[], int slab_start[], int slab_size[], std::string text)
{
    char* p = (char*)dataName.data();
    //status=NXmakedata(fileID, p, NX_FLOAT32, 2, dim);
    status=NXcompmakedata(fileID, p, NX_FLOAT32, 2, dim, NX_COMP_LZW, slab_size);
    status=NXopendata(fileID, p);
    status=NXputslab(fileID, dataValue, slab_start, slab_size);
    while(text != "")
    {
        NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
        break;
    }
    status=NXclosedata(fileID);
}

void ParseNXS::writeSlabData(NXstatus status, NXhandle fileID, const std::string dataName, const int64_t* dataValue, int dim[], int slab_start[], int slab_size[], std::string text)
{
    char* p = (char*)dataName.data();
    status=NXcompmakedata(fileID, p, NX_INT64, 2, dim, NX_COMP_LZW, slab_size);
    //status=NXmakedata(fileID, p, NX_INT64, 2, dim);
    status=NXopendata(fileID, p);
    status=NXputslab(fileID, dataValue, slab_start, slab_size);
    while(text != "")
    {
        NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
        break;
    }
    status=NXclosedata(fileID);
}
void ParseNXS::writeSlabData(NXstatus status, NXhandle fileID, const std::string dataName, const uint32_t* dataValue, int dim[], int slab_start[], int slab_size[], std::string text)
{
    char* p = (char*)dataName.data();
    //status=NXmakedata(fileID, p, NX_INT32, 2, dim);
    status=NXcompmakedata(fileID, p, NX_INT32, 2, dim, NX_COMP_LZW, slab_size);
    status=NXopendata(fileID, p);
    status=NXputslab(fileID, dataValue, slab_start, slab_size);
    while(text != "")
    {
        NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
        break;
    }
    status=NXclosedata(fileID);
}

//if dataValue is a variable, use &dataValue; if dataVale is 2D array, use *dataValue, if dataValue is 1D array, use dataValue
void ParseNXS::writeNumData(NXstatus status, NXhandle fileID, const std::string dataName, const float* dataValue, int dimension, int dim[], std::string text)
{
    char* p = (char*)dataName.data();
    status=NXmakedata(fileID, p, NX_FLOAT32, dimension, dim);
    status=NXopendata(fileID, p);
    status=NXputdata(fileID, dataValue);
    while(text != "")
    {
        NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
        break;
    }
    status=NXclosedata(fileID);
}
void ParseNXS::writeNumData(NXstatus status, NXhandle fileID, const std::string dataName, const int64_t* dataValue, int dimension, int dim[], std::string text)
{
    char* p = (char*)dataName.data();
    status=NXmakedata(fileID, p, NX_INT64, dimension, dim);
    status=NXopendata(fileID, p);
    status=NXputdata(fileID, dataValue);
    while(text != "")
    {
        NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
        break;
    }
    status=NXclosedata(fileID);
}
void ParseNXS::writeNumData(NXstatus status, NXhandle fileID, const std::string dataName, const uint64_t* dataValue, int dimension, int dim[], std::string text)
{
    char* p = (char*)dataName.data();
    status=NXmakedata(fileID, p, NX_INT64, dimension, dim);
    status=NXopendata(fileID, p);
    status=NXputdata(fileID, dataValue);
    while(text != "")
    {
        NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
        break;
    }
    status=NXclosedata(fileID);
}
void ParseNXS::writeNumData(NXstatus status, NXhandle fileID, const std::string dataName, const uint32_t* dataValue, int dimension, int dim[], std::string text)
{
    char* p = (char*)dataName.data();
    status=NXmakedata(fileID, p, NX_INT32, dimension, dim);
    status=NXopendata(fileID, p);
    status=NXputdata(fileID, dataValue);
    while(text != "")
    {
        NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
        break;
    }
    status=NXclosedata(fileID);
}

void ParseNXS::setPublic(ParseXML new_xml,string idfFilename)
{
    NXaccess mode(NXACC_RDWR);
    NXstatus status;
    NXhandle fileID;
    uint32_t compression(NX_COMP_LZW);
    status=NXopen(nxsfile.c_str(), mode, &fileID);
    status=NXopengroup(fileID,"csns","NXentry");
    map<string, string> publicFromSummary=new_xml.getPublic();
    writeCharData(status, fileID, "description", publicFromSummary["description"]);
    writeCharData(status, fileID, "beamline", publicFromSummary["beamline"]);
    writeCharData(status, fileID, "start_time_utc", publicFromSummary["start_time_utc"]);
    writeCharData(status, fileID, "end_time_utc", publicFromSummary["end_time_utc"]);
    writeCharData(status, fileID, "proposal_id", publicFromSummary["proposal_id"]);
    writeCharData(status, fileID, "instrument_name", publicFromSummary["instrument_name"]);
    writeCharData(status, fileID, "start_time_tai", publicFromSummary["start_time_tai"]);
    writeCharData(status, fileID, "end_time_tai", publicFromSummary["end_time_tai"]);
    writeCharData(status, fileID, "run_no", publicFromSummary["run_no"]);
    writeCharData(status, fileID, "measurement_type", publicFromSummary["measurement_type"]);
    writeCharData(status, fileID, "version", "1.0");
    writeCharData(status, fileID, "wavelength", publicFromSummary["wavelength"]);
    writeCharData(status, fileID, "proton_charge", publicFromSummary["proton_charge"]);
    writeCharData(status, fileID, "instrument_detector_file", "filename from detector group");
    writeCharData(status, fileID, "instrument_monitor_file", "filename from monitor group");
    std::string det_definition = "";
    std::string mon_definition = "";
    fstream fileidf;
    fileidf.open(idfFilename, std::ios::in);
    std::stringstream tmp1;
    tmp1<<fileidf.rdbuf();
    det_definition = tmp1.str();
    fileidf.close();
    //fileidf.open("./paramData/monitor.xml", std::ios::in);
    //std::stringstream tmp2;
    //tmp2<<fileidf.rdbuf();
    //mon_definition = tmp2.str();
    //fileidf.close();
    writeCharData(status, fileID, "instrument_detector_definition", det_definition);
    //writeCharData(status, fileID, "instrument_monitor_definition", mon_definition); 

    writeGroup(status, fileID, "event_data", "NXcollection");
    NXclosegroup(fileID); 
    writeGroup(status, fileID, "histogram_data", "NXcollection");
    NXclosegroup(fileID); 

    NXclosegroup(fileID); //close csns
    NXclose(&fileID);
    //cout<<"finish set pub"<<endl;
}

void ParseNXS::setPresentData(const int timeBin, const int timeStep)
{
    NXaccess mode(NXACC_RDWR);
    NXstatus status;
    NXhandle fileID;
    uint32_t compression(NX_COMP_LZW);
    status=NXopen(nxsfile.c_str(), mode, &fileID);

    int dim[1]={1};
    status=NXopengroup(fileID,"csns","NXentry");
    writeGroup(status, fileID, "present_data","NXdata");
    writeCharData(status, fileID, "plot", "TOF,intensity:intensity_error");
    writeCharData(status, fileID, "title", "Events Distribution");
    writeCharData(status, fileID, "type", "line");
    float* ptof = new float [timeBin];
    for(int i=0; i<timeBin; i++)
        ptof[i] = float(i*timeStep);
    dim[0]= timeBin;
    writeNumData(status, fileID, "TOF", ptof, 1, dim, "microsecond");
    delete [] ptof;
    uint32_t* pcounts = new uint32_t [timeBin];
    for(int i=0; i<timeBin; i++)
        pcounts[i] = i*timeStep;
    writeNumData(status, fileID, "intensity", pcounts, 1, dim, "counts");
    delete [] pcounts;
    float* perr = new float [timeBin];
    for(int i=0; i<timeBin; i++)
        perr[i] = 0.0 + ((float)rand()/(float)RAND_MAX)*(100.0-0.0);
    dim[0]=timeBin;
    writeNumData(status, fileID, "intensity_error", perr, 1, dim, "microsecond");
    delete [] perr;
    NXclosegroup(fileID); //close present_data
    NXclosegroup(fileID); //close csns
    NXclose(&fileID);
    //cout<<"finish present data"<<endl;
}

void ParseNXS::setProcess()
{
    NXaccess mode(NXACC_RDWR);
    NXstatus status;
    NXhandle fileID;
    uint32_t compression(NX_COMP_LZW);
    status=NXopen(nxsfile.c_str(), mode, &fileID);
    status=NXopengroup(fileID,"csns","NXentry");

    writeGroup(status, fileID, "process", "NXprocess");
    writeGroup(status, fileID, "process1", "NXnote");
    writeCharData(status, fileID, "date", "2017-12-13");
    writeCharData(status, fileID, "algorithm", "drone-1.3;nexus-1.0");
    writeCharData(status, fileID, "author", "csns");
    writeCharData(status, fileID, "description", "This is data reconstruction.");
    NXclosegroup(fileID); 
    NXclosegroup(fileID); //close process
    NXclosegroup(fileID); //close csns
    NXclose(&fileID);
    //cout<<"finish process"<<endl;
}

void ParseNXS::setUser(ParseXML new_xml)
{
    NXaccess mode(NXACC_RDWR);
    NXstatus status;
    NXhandle fileID;
    uint32_t compression(NX_COMP_LZW);
    status=NXopen(nxsfile.c_str(), mode, &fileID);
    status=NXopengroup(fileID,"csns","NXentry");

    writeGroup(status, fileID, "user", "NXuser");
    writeCharData(status, fileID, "facility_user_id", "zhangs");
    writeCharData(status, fileID, "address", "Zhongziyuan Road No.1, Dongguan, Guangdong, China");
    writeCharData(status, fileID, "email", "zhangs@126.com");
    writeCharData(status, fileID, "affiliation", "CSNS");
    writeCharData(status, fileID, "name", "S Zhang");
    writeCharData(status, fileID, "role", "principal_investigator");
    NXclosegroup(fileID); //close user
    NXclosegroup(fileID); //close csns
    NXclose(&fileID);
    //cout<<"finish user"<<endl;
}

void ParseNXS::setLogs(ParseXML new_xml)
{
    NXaccess mode(NXACC_RDWR);
    NXstatus status;
    NXhandle fileID;
    uint32_t compression(NX_COMP_LZW);
    status=NXopen(nxsfile.c_str(), mode, &fileID);
    status=NXopengroup(fileID,"csns","NXentry");
    writeGroup(status, fileID, "logs", "NXcollection");
    vector<CSNSlogs> m_log = new_xml.getLogs();
    vector<string>::iterator it;
    vector<CSNSlogs>::iterator it2;
    for(it2=m_log.begin(); it2!=m_log.end(); it2++)
    {
        writeGroup(status, fileID, (*it2).name.c_str(), "NXlog");
        for(it=(*it2).filePath.begin(); it!=(*it2).filePath.end(); it++)
        {
            cout<<(*it)<<endl;
        }
        NXclosegroup(fileID);
    } 
    NXclosegroup(fileID); //close logs
    NXclosegroup(fileID); //close csns
    NXclose(&fileID);
    //cout<<"finish logs"<<endl; 

    /*
       writeGroup(status, fileID, "proton_charge", "NXlog");
       for(it=m_log.proton_charge.begin(); it!=m_log.proton_charge.end(); it++){
       string filename=(*it);
       cout<<filename<<endl;
       }
       NXclosegroup(fileID);
       writeGroup(status, fileID, "sample_environment", "NXcollection");
       writeGroup(status, fileID, "temperature", "NXlog");
       for(it=m_log.sample_temperature.begin(); it!=m_log.sample_temperature.end();it++){
       string filename=(*it);
       cout<<filename<<endl;
       } 
       NXclosegroup(fileID);
       writeGroup(status, fileID, "pressure", "NXlog");
       for(it=m_log.sample_pressure.begin(); it!=m_log.sample_pressure.end();it++){
       string filename=(*it);
       cout<<filename<<endl;
       }
       NXclosegroup(fileID);
       writeGroup(status, fileID, "magnetic_field", "NXlog");
       for(it=m_log.sample_magnetic.begin(); it!=m_log.sample_magnetic.end();it++){
       string filename=(*it);
       cout<<filename<<endl;
       }
       NXclosegroup(fileID);
       writeGroup(status, fileID, "electric_field", "NXlog");
       for(it=m_log.sample_electric.begin(); it!=m_log.sample_electric.end();it++){
       string filename=(*it);
       cout<<filename<<endl;
       }
       NXclosegroup(fileID);
       NXclosegroup(fileID); //close se

       NXclosegroup(fileID);//close logs
       NXclosegroup(fileID); //close csns
       NXclose(&fileID);
       */

}

void ParseNXS::setInstrument(ParseXML new_xml)
{
    cout<<"start set instrument!"<<endl;
    NXaccess mode(NXACC_RDWR);
    NXstatus status;
    NXhandle fileID;
    uint32_t compression(NX_COMP_LZW);
    status=NXopen(nxsfile.c_str(), mode, &fileID);

    status=NXopengroup(fileID,"csns","NXentry");
    writeGroup(status, fileID, "instrument", "NXinstrument");

    CSNSmoderator moderatorFromSummary=new_xml.getModerator();
    setModerator(status, fileID, moderatorFromSummary);

    CSNSsource sourceFromSummary=new_xml.getSource();
    setSource(status, fileID, sourceFromSummary);
    CSNSsample sampleFromSummary=new_xml.getSample();
    setSample(status, fileID, sampleFromSummary);
    vector<CSNSse> se=new_xml.getSE();
    setSE(status, fileID, se);

    vector<CSNSdc> diskChopper=new_xml.getDC();
    setDC(status, fileID, diskChopper);    

    vector<CSNSaperture> aperture=new_xml.getAperture();
    setAperture(status, fileID, aperture);    

    vector<CSNSslit> slit=new_xml.getSlit();
    setSlit(status, fileID, slit);

    NXclosegroup(fileID);//close instrument
    NXclosegroup(fileID); //close csns
    NXclose(&fileID);
    cout<<"finish instrument"<<endl;
}

void ParseNXS::setModerator(NXstatus status, NXhandle fileID, CSNSmoderator moderatorFromSummary)
{
    int dim[1]={1};
    writeGroup(status, fileID, "moderator", "NXmoderator");
    writeCharData(status, fileID, "type", moderatorFromSummary.type);
    dim[0]=1;
    writeNumData(status, fileID, "distance", &moderatorFromSummary.distance, 1, dim, "m");
    writeNumData(status, fileID, "temperature", &moderatorFromSummary.temperature, 1, dim, "K");
    NXclosegroup(fileID);

}

void ParseNXS::setSource(NXstatus status, NXhandle fileID, CSNSsource sourceFromSummary)
{
    int dim[1]={1};
    writeGroup(status, fileID, "source", "NXsource");
    writeCharData(status,fileID,"name",sourceFromSummary.name);
    writeCharData(status,fileID,"type",sourceFromSummary.type);
    writeCharData(status,fileID,"probe",sourceFromSummary.probe);
    dim[0]=1;
    writeNumData(status, fileID, "frequency", &sourceFromSummary.frequency, 1, dim, "Hz");
    writeNumData(status, fileID, "power", &sourceFromSummary.power, 1, dim, "W");
    NXclosegroup(fileID);
}

void ParseNXS::setSample(NXstatus status, NXhandle fileID, CSNSsample sampleFromSummary)
{
    int dim[1]={1};
    writeGroup(status, fileID, "sample", "NXsample");
    writeCharData(status, fileID, "chemical_formula", sampleFromSummary.chemical_formula);
    writeCharData(status, fileID, "name", sampleFromSummary.name);
    writeCharData(status, fileID, "situation", sampleFromSummary.situation);
    writeCharData(status, fileID, "type", sampleFromSummary.type);    
    writeNumData(status, fileID, "density", &sampleFromSummary.density, 1, dim, "g cm-3");
    writeNumData(status, fileID, "mass", &sampleFromSummary.mass, 1, dim, "g");
    writeNumData(status, fileID, "distance", &sampleFromSummary.distance, 1, dim, "m");
    writeGroup(status, fileID, "geometry", "NXgeometry");
    writeGroup(status, fileID, "shape", "NXshape");
    writeCharData(status, fileID, "shape", sampleFromSummary.geometry.shape);
    dim[0] = 3;
    writeNumData(status, fileID, "size", sampleFromSummary.geometry.size, 1, dim, "m");
    NXclosegroup(fileID);
    writeGroup(status, fileID, "orientation", "NXorientation");
    dim[0] = 6;
    writeNumData(status, fileID, "value", sampleFromSummary.geometry.ori, 1, dim, "");
    NXclosegroup(fileID);
    writeGroup(status, fileID, "translation", "NXtranslation");
    dim[0] = 3;
    writeNumData(status, fileID, "distances", sampleFromSummary.geometry.distances, 1, dim, "");
    NXclosegroup(fileID);
    NXclosegroup(fileID);
    NXclosegroup(fileID);
    cout<<"finish set sample"<<endl;

}
void ParseNXS::setAperture(NXstatus status, NXhandle fileID, vector<CSNSaperture> aperture)
{
    int dim[1]={1};
    vector<CSNSaperture>::iterator it;
    for(it=aperture.begin();it!=aperture.end();it++)
    {
        const char* gName=(*it).apertureName.c_str();
        writeGroup(status, fileID, gName, "NXaperture");
        //cout<<(*it).xgap<<endl;
        writeNumData(status, fileID, "x_gap", &(*it).xgap, 1, dim, "mm");
        writeNumData(status, fileID, "y_gap", &(*it).ygap, 1, dim, "mm");
        NXclosegroup(fileID);
    }
    cout<<"finish set aperture!"<<endl;
}

void ParseNXS::setSlit(NXstatus status, NXhandle fileID, vector<CSNSslit> slit)
{
    int dim[1]={1};
    vector<CSNSslit>::iterator it;
    for(it=slit.begin();it!=slit.end();it++)
    {
        const char* gName=(*it).slitName.c_str();
        writeGroup(status, fileID, gName, "NXslit");
        writeNumData(status, fileID, "x_gap", &(*it).xgap, 1, dim, "mm");
        writeNumData(status, fileID, "y_gap", &(*it).ygap, 1, dim, "mm");
        NXclosegroup(fileID);
    }
    cout<<"finish set slit!"<<endl;
}



void ParseNXS::setSE(NXstatus status, NXhandle fileID, vector<CSNSse> se)
{
    writeGroup(status, fileID, "sample_environment", "NXcollection");
    vector<CSNSse>::iterator it_se;
    int dim[1] = {1};
    //cout<<"size="<<se.size()<<endl;       
    for(it_se=se.begin();it_se!=se.end();it_se++)
    {
        const char* gName=(*it_se).seName.c_str();
        //cout<<"gNamwe= "<<gName<<endl;
        writeGroup(status, fileID, gName, "NXenvironment");
        writeCharData(status,fileID,"name",(*it_se).name);
        //writeCharData(status,fileID,"type",(*it_se).type);
        //writeGroup(status, fileID, "electric_field", "NXcollection");

        //writeNumData(status, fileID, "electric_field", &((*it_se).electric_field), 1, dim, "N/C");
        //NXclosegroup(fileID);
        //writeGroup(status, fileID, "magnetic_field", "NXcollection");
        //writeNumData(status, fileID, "magnetic_field", &((*it_se).magnetic_field), 1, dim, "T");
        //NXclosegroup(fileID);
        //writeGroup(status, fileID, "pressure", "NXcollection");
        //writeNumData(status, fileID, "pressure", &((*it_se).pressure), 1, dim, "pa");
        //NXclosegroup(fileID);
        //writeGroup(status, fileID, "temperature", "NXcollection");
        //writeNumData(status, fileID, "temperature", &((*it_se).temperature), 1, dim, "K");
        //writeNumData(status, fileID, "t2", &(*it_se).t2, 1, dim, "K");
        //NXclosegroup(fileID);
        //writeGroup(status, fileID, gName, "NXnote");
        NXclosegroup(fileID);
    }
    NXclosegroup(fileID);
    cout<<"finish set SE"<<endl;
}

void ParseNXS::setDC(NXstatus status, NXhandle fileID, vector<CSNSdc> diskChopper)
{
    int dim[1]={1};
    vector<CSNSdc>::iterator it_dc;
    for(it_dc=diskChopper.begin();it_dc!=diskChopper.end();it_dc++)
    {
        const char* gName=((*it_dc).dcName).c_str();
        writeGroup(status, fileID, gName, "NXdisk_chopper");
        dim[0]=1;
        writeNumData(status, fileID, "phase", &(*it_dc).phase, 1, dim, "degree");
        writeNumData(status, fileID, "slit_angle", &(*it_dc).slitAngle, 1, dim, "degree");
        writeNumData(status, fileID, "rotation_speed", &(*it_dc).rotationSpeed, 1, dim, "Hz");
        writeNumData(status, fileID, "distance", &(*it_dc).distance, 1, dim, "m");
        NXclosegroup(fileID);
    }
}


void ParseNXS::setPid(NXstatus status, NXhandle fileID, int idstart, const int xpid, const int ypid)
{
    int dim2D[2]={ypid,xpid};
    //int64_t pid=int64_t(m_info["idstart"]);
    int64_t *pixelId = new int64_t [xpid*ypid];
    //cout<<"idstart= "<<pid<<endl;
    for (int i=0; i<xpid*ypid;i++){
        pixelId[i]=idstart;
        idstart++;
    }
    int slab_start[2]={0,0};
    int slab_size[2]={ypid, xpid};
    writeSlabData(status, fileID, "pixel_id", pixelId, dim2D, slab_start, slab_size, "");
    delete [] pixelId;
}

void ParseNXS::setTof(NXstatus status, NXhandle fileID,const int tStart, const int tBin, const int tStep, const int delay)
{
    int dim[1]={0};
    uint32_t* timeOfFlight = new uint32_t [tBin];
    int tDelay=0;
    if(delay>1)
        tDelay = delay;
    for(uint32_t i=0; i<tBin; i++)
        timeOfFlight[i]=tStart+tDelay+i*tStep;
    dim[0]=tBin;
    writeNumData(status, fileID, "time_of_flight", timeOfFlight, 1, dim, "");
    delete [] timeOfFlight;
}

void ParseNXS::setPidSize(NXstatus status, NXhandle fileID, map<string, float> m_info, const int xpid, const int ypid)
{
    float * x_pixel_size=new float [xpid*ypid];
    float * y_pixel_size=new float [xpid*ypid];
    float z_pixel_size=0.0005;
    for(int i=0; i<xpid*ypid; i++){
        x_pixel_size[i] = float(m_info["xstep"]);
        y_pixel_size[i] = float(m_info["ystep"]);
    }
    //cout<<1111<<endl;
    int dim[1]={1};
    int dim2D[2]={ypid, xpid};
    int slab_start[2]={0,0};
    int slab_size[2]={ypid,xpid};
    writeSlabData(status, fileID, "x_pixel_size", x_pixel_size, dim2D, slab_start, slab_size, "");
    writeSlabData(status, fileID, "y_pixel_size", y_pixel_size, dim2D, slab_start, slab_size, "");
    writeNumData(status, fileID, "z_pixel_size", &z_pixel_size, 1, dim, "");
    delete [] x_pixel_size;
    delete [] y_pixel_size;
}

void ParseNXS::setCoordinate_module(NXstatus status, NXhandle fileID, map<string, float> m_info, const int xpid, const int ypid)
{
    int dim2D[2]={ypid, xpid};
    float *x=new float[xpid*ypid];
    float *y=new float[xpid*ypid];
    float *z=new float[xpid*ypid];
    int num=0;
    for (int i=0; i<xpid; i++){
        for (int j=0; j<ypid;j++){
            float tmpx=float(m_info["x"])+j*float(m_info["xstep"]);
            float tmpy=float(m_info["y"])+i*float(m_info["ystep"]);
            float tmpz=float(m_info["z"]);
            z[num]= -sin(float(m_info["val"])/180*M_PI)*(tmpx-float(m_info["x"]))+tmpz;
            x[num]= float(m_info["x"]) +cos(float(m_info["val"])/180*M_PI)*(tmpx-float(m_info["x"]));
            y[num]= tmpy;
        }
        num++;
    }
    float *ra_distance=new float [xpid*ypid];
    float *az_angle=new float [xpid*ypid];
    float *po_angle=new float [xpid*ypid];
    for (int i=0; i<xpid*ypid; i++){
        ra_distance[i]= sqrt(x[i]*x[i]+y[i]*y[i]+z[i]*z[i]);
        az_angle[i]= 180/M_PI*acos(z[i]/ra_distance[i]);
        po_angle[i]= 180/M_PI*atan(y[i]/x[i]);
    }
    int slab_start[2]={0,0};
    int slab_size[2]={ypid,xpid};
    writeSlabData(status, fileID, "radial_distance", ra_distance, dim2D, slab_start, slab_size, "");
    writeSlabData(status, fileID, "polar_angle", po_angle, dim2D, slab_start, slab_size, "");
    writeSlabData(status, fileID, "azimuthal_angle", az_angle, dim2D, slab_start, slab_size, "");
    delete [] x;
    delete [] y;
    delete [] z;
    delete [] ra_distance;
    delete [] az_angle;
    delete [] po_angle;
}

void ParseNXS::setDetector(string dataPath, CSNSdet det_info, ParseXML idf_xml, json conf_json, const std::vector<string> &dName)
{
    cout<<"start set detector: "<<endl;
    NXaccess mode(NXACC_RDWR);
    NXstatus status;
    NXhandle fileID;
    uint32_t compression(NX_COMP_LZW);
    status=NXopen(nxsfile.c_str(), mode, &fileID);
    int dim[1]={1};
    int slab_start[2]={0,0};

    uint64_t evtNum=0;
    status=NXopengroup(fileID,"csns","NXentry");
    status=NXopengroup(fileID,"instrument","NXinstrument");

    string inst = conf_json.find("instrument").value();

    int timeDelay=int(det_info.delay);
    cout<<"time delay: "<<timeDelay<<endl; 
    timeStart=int(conf_json.find("tofstart").value());
    timeBin=int(conf_json.find("tofbin").value())+1;
    timeStep=int(conf_json.find("tofstep").value());
    cout<<"timeStart: "<<timeStart<<endl;

    for(auto it=dName.begin(); it!=dName.end(); it++){
        map<string, float> m_info;
        string name = (*it);
        dim[0] = 1;
        writeGroup(status, fileID, name.c_str(), "NXdetector");
        writeNumData(status, fileID, "delay", &det_info.delay, 1, dim, "");
        if(inst == "MR")
        {
            writeCharData(status, fileID, "local_name", det_info.name);
            writeCharData(status, fileID, "mode", det_info.mode);
            writeNumData(status, fileID, "rotate_angle", &det_info.rotate_angle, 1, dim, "");
            //getEventData(dataPath, evtNum, pid, tof, pulse);
        }

        m_info=idf_xml.getModuleInfo(name.c_str());
        xpids = int(m_info["xpixels"]);
        ypids = int(m_info["ypixels"]);

        int dim2D[2]={xpids*ypids, timeBin-1};
        pidStart=(m_info["idstart"]);
        cout<<"pid start = "<<pidStart<<endl;
        cout<<"pid step = "<<m_info["idstepbyrow"]<<endl;
        setPidSize(status, fileID, m_info, xpids, ypids);
        setCoordinate_module(status, fileID, m_info, xpids, ypids);
        setTof(status, fileID, timeStart,timeBin, timeStep, timeDelay);
        //cout<<333<<endl;

        std::vector<uint32_t> histData;
        getHistDataFromDrone(dataPath, name, histData);
        int slab_size[2]={ypids*xpids,(timeBin-1)};
        writeSlabData(status, fileID, "histogram_data",histData.data(), dim2D,slab_start, slab_size, "");
        setPid(status, fileID, pidStart, xpids, ypids);   

        std::vector<int64_t> pid;
        std::vector<float> tof;
        std::vector<uint64_t> pulse;
        cout<<"strat get evt"<<endl;
        getEvtDataFromDrone(dataPath,name,evtNum,pid,tof,pulse); 
        dim[0]= evtNum;
        writeNumData(status, fileID, "event_pixel_id", pid.data(), 1, dim, "");
        //cout<<321<<endl;
        writeNumData(status, fileID, "event_time_of_flight", tof.data(), 1, dim, "");
        writeNumData(status, fileID, "event_pulse_time", pulse.data(), 1, dim, "");

        cout<<"finish set evt"<<endl;
        NXclosegroup(fileID);//close module
    } 
    NXclosegroup(fileID); //close instrument
    NXclosegroup(fileID); //close csns
    NXclose(&fileID); 
}

void ParseNXS::setMonitor(std::vector<string> fileList, CSNSdet mon_info, json conf_json,const std::vector<string> &mName)
{
    cout<<"start set monitor: "<<endl;
    NXaccess mode(NXACC_RDWR);
    NXstatus status;
    NXhandle fileID;
    uint32_t compression(NX_COMP_LZW);
    status=NXopen(nxsfile.c_str(), mode, &fileID);
    int dim[1]={1};
    int slab_start[2]={0,0};

    status=NXopengroup(fileID,"csns","NXentry");
    status=NXopengroup(fileID,"instrument","NXinstrument");
    int pstart = 1;
    int timeDelay=int(mon_info.delay);
    cout<<"time delay: "<<timeDelay<<endl;
    timeStart=int(conf_json.find("montofstart").value());
    timeBin=int(conf_json.find("montofbin").value())+1;
    timeStep=int(conf_json.find("montofstep").value());
    cout<<"timeStart: "<<timeStart<<endl;
    string name="";
    int i = 0;
    for(auto it=mName.begin(); it!=mName.end(); it++){
        name = *it;   
        cout<<name<<endl; 
        auto tmp = conf_json.find(name).value();
        xpids = int(tmp.find("xpids").value());
        ypids = int(tmp.find("ypids").value());
        

        int dim2D[2]={xpids*ypids, timeBin-1};
        writeGroup(status, fileID, name.c_str(), "NXdetector");
        setTof(status, fileID, timeStart,timeBin, timeStep, timeDelay);
        std::vector<uint32_t> histData;
        name = fileList[i];
        getMonitorData(name,xpids*ypids,timeBin, histData);

        int slab_size[2]={ypids*xpids,(timeBin-1)};
        writeSlabData(status, fileID, "histogram_data",histData.data(), dim2D,slab_start, slab_size, "");
        cout<<"finish set hist"<<endl;
        setPid(status, fileID,pstart, xpids, ypids);   
        pstart +=1024;
        i++;
        NXclosegroup(fileID);
    }
    NXclosegroup(fileID); //close instrument
    NXclosegroup(fileID); //close csns
    NXclose(&fileID); 
}

void ParseNXS::setEventData(const std::vector<string> &dName)
{
    NXaccess mode(NXACC_RDWR);
    NXstatus status;
    NXhandle fileID;
    uint32_t compression(NX_COMP_LZW);
    status=NXopen(nxsfile.c_str(), mode, &fileID);
    status=NXopengroup(fileID,"csns","NXentry");
    //writeGroup(status, fileID, "event_data", "NXcollection");
    //NXclosegroup(fileID);
    for(auto it = dName.begin(); it != dName.end(); it++){
        string name = *it;
        NXlink eventPixelIdLink;
        NXlink eventPulseTimeLink;
        NXlink eventTimeOfFlightLink;
        string path ="/csns/instrument/"+name;
        string pathEventPixelId = path+"/event_pixel_id";
        string pathEventPulseTime = path+"/event_pulse_time";
        string pathEventTimeOfFlight = path+"/event_time_of_flight";
        string pathEventData="/csns/event_data";
        status=NXopenpath(fileID, pathEventPixelId.c_str());
        status=NXgetdataID(fileID, &eventPixelIdLink);
        status=NXopenpath(fileID, pathEventPulseTime.c_str());
        status=NXgetdataID(fileID, &eventPulseTimeLink);
        status=NXopenpath(fileID, pathEventTimeOfFlight.c_str());
        status=NXgetdataID(fileID, &eventTimeOfFlightLink);
        status=NXopenpath(fileID, pathEventData.c_str());

        writeGroup(status, fileID, name.c_str(), "NXevent_data");
        status=NXmakelink(fileID, &eventPixelIdLink);
        status=NXmakelink(fileID, &eventPulseTimeLink);
        status=NXmakelink(fileID, &eventTimeOfFlightLink);
        NXclosegroup(fileID);
        NXclosegroup(fileID);//close event
    }

    NXclosegroup(fileID);//close csns
    NXclose(&fileID);
    //cout<<" finish event_data"<<endl;
}
void ParseNXS::setHistData(const std::vector<string> &dName)
{
    NXaccess mode(NXACC_RDWR);
    NXstatus status;
    NXhandle fileID;
    uint32_t compression(NX_COMP_LZW);
    status=NXopen(nxsfile.c_str(), mode, &fileID);
    status=NXopengroup(fileID,"csns","NXentry");
    //writeGroup(status, fileID, "histogram_data", "NXcollection");
    //NXclosegroup(fileID);
    for (auto it = dName.begin(); it != dName.end(); it++)
    {
        string name = *it;
        string path ="/csns/instrument/"+name;
        NXlink HistTimeOfFlightLink;
        NXlink HistValueLink;
        string pathValue = path+"/histogram_data";
        string pathTimeOfFlight = path+"/time_of_flight";
        string pathHistData="/csns/histogram_data";
        status=NXopenpath(fileID, pathValue.c_str());
        status=NXgetdataID(fileID, &HistValueLink);
        status=NXopenpath(fileID, pathTimeOfFlight.c_str());
        status=NXgetdataID(fileID, &HistTimeOfFlightLink);
        status=NXopenpath(fileID, pathHistData.c_str());

        writeGroup(status, fileID, name.c_str(), "NXdata");
        status=NXmakelink(fileID, &HistValueLink);
        status=NXmakelink(fileID, &HistTimeOfFlightLink);
        NXclosegroup(fileID);
        NXclosegroup(fileID);//close hist
    }
    NXclosegroup(fileID);//clsoe csns
    NXclose(&fileID);

    //cout<<" finish histogram_data"<<endl;
}

