#include<iostream>
#include<string>
#include<vector>
#include <tinyxml.h>
#include <fstream>
#include "NeXusFile.hpp"
#include <map>
#include "parseXML.h"
#include "parseNXS.h"
#include <math.h>
#include <memory.h>
#include <stdio.h>
#include <typeinfo>
#include <dirent.h>
#include <unistd.h>
#include <nlohmann/json.hpp>
using json = nlohmann::json;
using namespace std;

int dim[1]={0};

bool dirExists(const string& dirName_in)
{
    int ftyp = access(dirName_in.c_str(), 0);
    if (0 == ftyp)
        return true;   // this is a directory!  
    else
        return false;
}

ParseNXS createNXS(string nxsfilename)
{
    ParseNXS data(nxsfilename);
    NXaccess mode(NXACC_CREATE5);
    NXstatus status;
    NXhandle fileID;
    uint32_t compression(NX_COMP_LZW);
    status=NXopen(nxsfilename.c_str(), mode, &fileID);
    status=NXmakegroup(fileID,"csns","NXentry");
    status=NXopengroup(fileID,"csns","NXentry");
    //status=NXmakegroup(fileID,"histogram_data","NXcollection");
    //status=NXopengroup(fileID,"histogram_data","NXcollection");
    NXclosegroup(fileID); //close histogram_data
    NXclosegroup(fileID); //close csns
    NXclose(&fileID);
    return data;
}



    

std::vector<string> getFile(string filepath, string midName, string houzhui)
{
    std::vector<string> filename; 
    if(dirExists(filepath))
    {
        DIR *dirp;
        struct dirent *dp;
        dirp=opendir(filepath.c_str());
        while((dp = readdir(dirp))!=NULL)
        {
            string name = dp->d_name;
            int num=name.size();
            if((name.size()>4) && (name.substr(num-3,3)==houzhui))
            {   
                auto iPos = name.find(midName);
                if(iPos!=name.npos)
                    filename.push_back(filepath+"/"+name);
            }
        }
    }else{;} 
   return filename;
}
/*
string getOnlyFile(const std::vector<string> &fileList)
{
    string filename = "";
    if (fileList.size()==1)
        filename=fileList[0];
    return filename;
}
*/
string getDAQFile(const std::vector<string> &fileList, string name)
{
    string filename="";
    for(auto i = fileList.begin(); i!=fileList.end();i++)
    {
        auto iPos = (*i).find(name);
        if(iPos != (*i).npos)
        {    
            filename = *i; 
            break;
        }
    }
    return filename;
}


int main(int argc, char *argv[])
{
    if(argc<=1)
    {
        printf("Usage:%s runNumber prepath\n", argv[0]);
        return 0;
    }
    string runno=argv[1];
    
    // get json file
    ifstream f("test.json");
    json confJSON;
    f >> confJSON;

    //get control file
    bool dirExists(const string&);
    string tmp = confJSON.find("controlPath").value();
    string filepath = tmp+"/"+runno;
    
    int no = atoi(runno.substr(3).c_str());
    stringstream ss;
    ss<<no;
    string run = ss.str();

    std::vector<string> fileList = getFile(filepath,run,"xml");
    string sumfile="";
    if(fileList.size()==1)
        sumfile = fileList[0];
    fileList.clear();

    //get daq file
    string prepath=confJSON.find("prepath").value();
    auto tmp2 = confJSON.find("detector").value(); 
    std::vector<string> dName;
    for(auto i = 0; i!=tmp2.size();i++)
        dName.push_back(tmp2[i]);
    tmp2.clear();
    string daqfile=""; 
    filepath=prepath+"/"+runno+"/tmpData";
    fileList = getFile(filepath,"hist","dat");
    if(fileList.size()==dName.size())
        daqfile = filepath;

    //get monitor file
    tmp2 = confJSON.find("monitor").value();
    string monPrepath = confJSON.find("monitorPath").value();
    std::vector<string> monFileList;
    std::vector<string> mName;
    for (auto it = tmp2.begin();it!=tmp2.end();it++)
    {
        string name=*it;
        name[0]=toupper(name[0]);
        string path = monPrepath+"/"+name+"/"+runno;
        cout<<path<<endl;
        std::vector<string> tmpList = getFile(path, run,"bin");
        if(tmpList.size()==1)
        {
            monFileList.push_back(tmpList[0]);
            mName.push_back(*it);
        }
        tmpList.clear();
    }
    tmp2.clear();
    cout<<sumfile<<":"<<daqfile<<endl;
    bool judge =false;
    string inst = confJSON.find("instrument").value();
        
    if ((sumfile!="")&&(daqfile!=""))
    {
        if(inst=="MR")
        {    judge = true;
        }else{
            if (mName.size()!=0)
                judge = true;
        }
    }
    cout<<judge<<endl;


    if(judge)
    {

        // parse summary
        ParseXML sumXML(sumfile);
        //get detector
        CSNSdet det_info = sumXML.getDetector();
        
        CSNSdet mon_info;
        if(inst=="MR")
            mon_info = sumXML.getMonitor();
       
        //get xml file
        string idffile="";
        tmp = confJSON.find("idfPath").value();
        if (inst=="MR")
        {
            string detType = det_info.mode;
            idffile= tmp+"/bank_"+detType+".xml";
        }else{
            idffile=tmp+"/bank.xml";
        }
        ParseXML idfXML(idffile);

        //create nexus file 
        string nxsfile=prepath+"/"+runno+"/detector.nxs";
    /*
    if (inst=="MR")
    {
        tmp = confJSON.find("daqPath").value();
        filepath = tmp +"/"+runno;
        fileList = getFile(filepath,runno,"dat");
        daqfile = getDAQFile(fileList, "He3MODULE");
        cout<<daqfile<<endl;
    }else{
        daqfile=prepath+"/"+runno+"/tmpData";
    }
    */

        auto m_nxs = createNXS(nxsfile);
        m_nxs.setPublic(sumXML,idffile);

        m_nxs.setInstrument(sumXML);
        m_nxs.setDetector(daqfile, det_info, idfXML, confJSON, dName);
        if(inst == "MR")
        {;}else{
            m_nxs.setMonitor(monFileList, mon_info, confJSON, mName);
            m_nxs.setHistData(mName);
        }
        // m_nxs.setPresentData(10000,4);
        //m_nxs.setUser();
        //m_nxs.setProcess();
        //m_nxs.setLogs(sumXML);
        m_nxs.setEventData(dName);
        m_nxs.setHistData(dName);
        cout<<"finish save nexus"<<endl;
        string path = prepath+"/"+runno+"/complete.dat";
        std::ofstream markfile;
        markfile.open(path.c_str());
        markfile<<"completed"<<endl;
        markfile.close(); 
     
    }else{
        string name2="";
        if (sumfile=="") 
            name2+="noControl";
        if(daqfile=="")
            name2+="noDaq";
        if(mName.size()==0)
            name2+="noMonitor";
        string path2=prepath+"/"+runno+"/"+name2+".dat";
        std::ofstream markfile;
        markfile.open(path2.c_str());
        markfile<<"not finished"<<endl;
        markfile.close(); 
    }

    return 0;
}

