# - Find NeXus library
# Find the native NEXUS includes and library
# This module defines
#  NEXUS_INCLUDE_DIR, where to find NeXus.h, etc.
#  NEXUS_LIBRARY, library to link against to use NEXUS
#  NEXUS_FOUND, if false, do not try to use NEXUS.

#find_path(TINYXML_INCLUDE_DIR tinyxml.h
#  HINTS "/usr/include"
#)
# find position of napi.h from the end
FIND_PATH(TINYXML_INCLUDE_DIR NAMES "tinyxml.h")
MARK_AS_ADVANCED(TINYXML_INCLUDE_DIR)
#message (${TINYXML_INCLUDE_DIR})

find_library(TINYXML_LIBRARY tinyxml)
#message (${TINYXML_LIBRARY})

# get version string

# handle the QUIETLY and REQUIRED arguments and set NEXUS_FOUND to TRUE if
# all listed variables are TRUE
include(${CMAKE_ROOT}/Modules/FindPackageHandleStandardArgs.cmake)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(TINYXML
                                  REQUIRED_VARS TINYXML_LIBRARY TINYXML_INCLUDE_DIR)

if (NOT TINYXML_FOUND)
  unset(TINYXML_LIBRARY)
endif()

mark_as_advanced(TINYXML_LIBRARY)
