
#include <dic.hxx>
#include <iostream>
#include <vector>
#include <string>
#include <fstream>
#include <memory>
#include <chrono>
#include <future>
#include <nlohmann/json.hpp>

#include "Action_GPPD.hh"
#include "Earthworm.hh"


Action_GPPD::Action_GPPD(RedisIO *redis, MyStateMachine *sMachine)
: Action(redis),  m_detType(Hist2DMap::DetectorType::kUnknown),
  m_hist( nullptr),
	m_sMachine(sMachine), m_active_daq(nullptr)
{
  std::ifstream f("../allPathGPPD.json");
  m_allPath.clear();
  f >> m_allPath;
  f.close();

  m_active_daq = new DAQInterface(m_allPath["dimserver"],1000);
}

Action_GPPD::~Action_GPPD()
{
	delete m_active_daq;

	EW_LOG_INFO("~Action_GPPD ref count of histmap is {}", m_hist.use_count());
	m_hist.reset();
}

bool Action_GPPD::configure()
{
	//fixme: update m_allPath fisrt !!!!!

	std::ifstream f("../allPathGPPD.json");
	m_allPath.clear();
	f >> m_allPath;
  f.close();

  //construct histogram add couple with daq
  unsigned pid_num(1344), tof_num(2500);
	m_hist.reset(new NumpyHist2D ( tof_num*4, 0., tof_num*16, pid_num, 0.-0.5, pid_num-0.5));

  m_active_daq->setHist2D(m_hist);

  //send pid
	std::vector<double> pid;
	for(unsigned i=0;i<pid_num;i++)
		pid.push_back(i+1230001);
	RedisNumpy nvt;
	std::string pidstr;
	std::vector<uint64_t> shape;
	shape.push_back(pid_num);
	nvt.makeNumpyArr(pid, RedisNumpy::data_type::f8,
									 shape, pidstr);
	m_redis->writeString(m_allPath["rawDataPixel"], pidstr);

  //send tof id
	std::vector<double> tof;
	for(unsigned i=0;i<tof_num+1;i++)
	{
		tof.push_back(i*16);
	}
	std::string tofstr;
	shape[0]=(tof_num+1);
	nvt.makeNumpyArr(tof, RedisNumpy::data_type::f8,
									 shape, tofstr);
	m_redis->writeString(m_allPath["rawDataTof"], tofstr);

  //send empty hist
  std::vector<double> h(pid_num*tof_num, 0.);
  std::string histstr;
  shape[0] = pid_num*tof_num*4;
  nvt.makeNumpyArr(h, RedisNumpy::data_type::f8,
                   shape, histstr);
  m_redis->writeString(m_allPath["rawDataHist"], histstr);

	m_hist->reset();
  m_active_daq->reset();

	EW_LOG_INFO("configure:: Configuration completed. ");
	return true;
}

//Stop running and clear any runtime determined parameter
bool Action_GPPD::unconfigure()
{
	m_active_daq->setActive(false);
	EW_LOG_INFO("unconfigure:: Earthworm unconfigured.");
	return true;
}

//Start accumulate data, RESET AGAIN HERE
bool Action_GPPD::start()
{
  unsigned dsize = 4600*2500;
  std::vector<double> h(dsize, 0.);
  std::string histstr;
  std::vector<uint64_t> shape;
  shape.push_back(dsize);
  RedisNumpy nvt;
  nvt.makeNumpyArr(h, RedisNumpy::data_type::f8,
                   shape, histstr);
  m_redis->writeString(m_allPath["rawDataHist"], histstr);


	m_active_daq->setActive(false);
	m_hist->reset();
	m_active_daq->setActive(true);
  m_active_daq->reset();

	m_startTime = std::chrono::steady_clock::now();
  EW_LOG_INFO("start:: Run started.");

	return true;
}

//Paused fill histogram, still receive but unprocess dim datastream
bool Action_GPPD::pauseStop()
{
	m_active_daq->setActive(false);
	EW_LOG_INFO("pauseStop:: kPause or kStop.");
	return true;
}

bool Action_GPPD::abort()
{
	m_active_daq->setActive(false);
	EW_LOG_INFO("abort:: aborting");
	return true;
}

//Restart running
bool Action_GPPD::resume()
{
	m_active_daq->setActive(true);
	EW_LOG_INFO("resume:: kResume.");
	return true;
}

bool Action_GPPD::kill()
{
	if(m_active_daq)
		m_active_daq->setActive(false);
	m_kill=true;
	return true;
}


void Action_GPPD::sendHeartbeat(bool stateAsStr)
{
  nlohmann::json j;
  j["pid"] =std::to_string(m_proID);
	if(stateAsStr)
	  j["status"] = m_sMachine->printState();
  else
		j["status"] = std::to_string(m_sMachine->getState());

  std::time_t t = std::time(nullptr);
  char mbstr[100];
  if (std::strftime(mbstr, sizeof(mbstr), "%Y-%m-%dT%H:%M:%S.%03d+08:00", std::localtime(&t))) {
  }

  j["timestamp"] = std::string (mbstr);
  std::string hb= j.dump();
	std::cout << "Heartbeart " << hb  << '\n';

  m_redis->writeString(m_allPath["hbEarthworm"],hb);

  if(m_active_daq)
    m_redis->writeString(m_allPath["pulstCnt"],std::to_string(m_active_daq->getDataFlow().num_dim_trigger));

}

bool Action_GPPD::update()
{
	std::string str = m_redis->readString(m_allPath["ctrlEarthworm"]);
  return m_sMachine->transit(atoi(str.c_str()));
}

bool Action_GPPD::keepRunning()
{
	EW_LOG_INFO("keepRunning:: Keep running");

	std::string redisDataStr;
	double totcnt = m_hist->getIntegral();
	double cnt_rate=0.;
	if(totcnt)
  {
		cnt_rate=totcnt/std::chrono::duration_cast<std::chrono::milliseconds>(std::chrono::steady_clock::now() - m_startTime).count()*1000;
		EW_LOG_INFO("keepRunning:: Data integral {}, rate is {} event/s", totcnt,
							cnt_rate);
  }
	else
		EW_LOG_INFO("keepRunning:: Data integral is 0");

	m_redis->writeString(m_allPath["DetCnt"], std::to_string((int) m_hist->getIntegral()) );
	m_redis->writeString(m_allPath["DetCntRate"], std::to_string(cnt_rate) );
  m_hist->serialise(redisDataStr);
  m_redis->writeString(m_allPath["rawDataHist"], redisDataStr);
	return true;
}
