#ifndef NumpyHist1D_hh
#define NumpyHist1D_hh

#include "NumpyHistBase.hh"


class NumpyHist1D : public NumpyHistBase {
public:
  explicit NumpyHist1D(unsigned nbins, double xmin, double xmax);
  virtual ~NumpyHist1D();

  unsigned dimension() const override { return 1; }  ;
  void serialise(std::string &serialised) const override;

  void fill(double val);
  void fill(double val, double weight);

private:
  double m_binfactor;
};




#endif
