#include "DAQInterfaceGPPD.hh"
#include "DaqTaskGPPD.hh"


DAQInterfaceGPPD::DAQInterfaceGPPD(std::string daq_name,
                           unsigned houseKeeping_itervl_ms,  unsigned merge_xnum, unsigned merge_ynum)
: DAQInterface(daq_name, houseKeeping_itervl_ms), m_merge_xnum(merge_xnum), m_merge_ynum(merge_ynum)
{

}

DAQInterfaceGPPD::~DAQInterfaceGPPD()
{

}

void DAQInterfaceGPPD::setHist2D(std::shared_ptr<NumpyHist2D>& hist)
{
  std::lock_guard<std::mutex> guard(m_task_mutex);
  m_hist2d = hist;
}

bool DAQInterfaceGPPD::pushBackTask(uint8_t *data, size_t dsize)
{
  if(m_hist2d.get())
  {
    m_tasks.emplace_back( std::shared_ptr<DaqTask>( new DaqTaskGPPD(data, data+dsize, m_hist2d, m_merge_xnum, m_merge_ynum)));
    return true;
  }
  return false;
}
