#ifndef DimRecv_DaqTaskGPPD_hh
#define DimRecv_DaqTaskGPPD_hh

#include <future>
#include <vector>
#include <mutex>

#include "DaqTask.hh"
#include "NumpyHist2D.hh"

class DaqTaskGPPD : public DaqTask {
public:
  DaqTaskGPPD(uint8_t* begin, uint8_t* end, std::shared_ptr<NumpyHist2D>& hist, unsigned merge_xnum, unsigned merge_ynum);
  virtual ~DaqTaskGPPD();

private:
  uint64_t run() override;
  std::shared_ptr<NumpyHist2D> m_hist2d;
  unsigned m_merge_xnum, m_merge_ynum;

};

#endif
