#include <cstdio>
#include <fstream>
#include <vector>
#include <string>
#include <iostream>
#include <fstream>


#include "ParserUtils.hh"
#include "PackageMWPC.hh"
#include "Hist2DMap.hh"
#include "NumpyHist1D.hh"

int main(int argc, char *argv[])
{
  //read data

  //std::string fname = "/home/caixx/ownCloud/Work/DIM/data/BL02_RUN0005005_MWPCpackage_FILE001_20190609130207.dat";
  std::string fname = "/home/caixx/ownCloud/Work/DIM/data/mwpc_online/mwpc1583547507_907.bin";

  if(argc==2)
    fname=std::string(argv[1]);
  std::ifstream source(fname, std::ifstream::ate|std::ios_base::binary);

  // get length of file:
  source.seekg (0, source.end);
  int length = source.tellg();
  source.seekg (0, source.beg);

  // allocate memory:
  const uint8_t * buffer = new uint8_t [length];

  // read data as a block:
  source.read (reinterpret_cast<char*>(const_cast<uint8_t *>(buffer)),length);
  source.close();
  // printf("file size is %g MB \n", length/1024./1024);

  const uint8_t * const data_end = buffer+length;
  double time_window = 40;
  double charge_threshold = 10;
  Parser::PackageMWPC mwpc(charge_threshold,time_window);


  const uint8_t * abuf = buffer;

  unsigned pid_num(4600), tof_num(2500);
  Hist2DMap histmap(tof_num, 0 , 40000, pid_num, -.5, pid_num-.5 , Hist2DMap::DetectorType::kMWPC);


  std::vector<Parser::HitInfo> hitinfo;
  unsigned event_cnt(0);

  while(mwpc.readNextPackage(abuf, data_end, hitinfo))
  {

    unsigned pkgevt = hitinfo.size();
    event_cnt += pkgevt;

    if(pkgevt){
        for(auto const& hit:hitinfo)
        {
          int x = hit.pos/2.2;
          int y = hit.posy/4;
          histmap.fill(1 , hit.t, x+y*92 );
        }
    }

    if(event_cnt%100==0)
      std::cout << "event count " << event_cnt << '\n';

  }
  hitinfo.clear();
  mwpc.process(hitinfo);
  std::cout << "event count " << event_cnt+hitinfo.size() << '\n';



  delete [] buffer;
  return 0;

}
